/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.postgresql.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.derby.drda.NetworkServerControl;

public class DerbyDevServicesProcessor {
    static final int NUMBER_OF_PINGS = 10;
    static final int SLEEP_BETWEEN_PINGS = 500;

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupDerby() {
        return new DevServicesDatasourceProviderBuildItem("derby", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, Optional<String> imageName, Map<String, String> additionalProperties, OptionalInt fixedExposedPort) {
                try {
                    final int port = fixedExposedPort.isPresent() ? fixedExposedPort.getAsInt() : 1527;
                    NetworkServerControl server = new NetworkServerControl(InetAddress.getByName("localhost"), port);
                    server.start(new PrintWriter(System.out));
                    for (int i = 1; i <= 10; ++i) {
                        try {
                            System.out.println("[INFO] Attempt " + i + " to see if Derby Network server started");
                            server.ping();
                            break;
                        }
                        catch (Exception ex) {
                            if (i == 10) {
                                System.out.println("Derby Network server failed to start");
                                ex.printStackTrace();
                                throw ex;
                            }
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    StringBuilder additionalArgs = new StringBuilder();
                    for (Map.Entry<String, String> i : additionalProperties.entrySet()) {
                        additionalArgs.append(";");
                        additionalArgs.append(i.getKey());
                        additionalArgs.append("=");
                        additionalArgs.append(i.getValue());
                    }
                    return new DevServicesDatasourceProvider.RunningDevServicesDatasource("jdbc:derby://localhost:" + port + "/memory:" + datasourceName.orElse("quarkus") + ";create=true" + additionalArgs.toString(), null, null, new Closeable(){

                        @Override
                        public void close() throws IOException {
                            try {
                                NetworkServerControl server = new NetworkServerControl(InetAddress.getByName("localhost"), port);
                                server.shutdown();
                                System.out.println("[INFO] Derby database was shut down");
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                catch (Exception throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
    }
}

