/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.mssql.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.devservices.common.Labels;
import io.quarkus.devservices.common.Volumes;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.utility.DockerImageName;

public class MSSQLDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(MSSQLDevServicesProcessor.class);
    private static final String DEFAULT_USERNAME = "sa";

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupMSSQL(final List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem) {
        return new DevServicesDatasourceProviderBuildItem("mssql", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, String datasourceName, DevServicesDatasourceContainerConfig containerConfig, LaunchMode launchMode, Optional<Duration> startupTimeout) {
                QuarkusMSSQLServerContainer container = new QuarkusMSSQLServerContainer(containerConfig.getImageName(), containerConfig.getFixedExposedPort(), !devServicesSharedNetworkBuildItem.isEmpty());
                startupTimeout.ifPresent(arg_0 -> ((QuarkusMSSQLServerContainer)container).withStartupTimeout(arg_0));
                String effectivePassword = containerConfig.getPassword().orElse(password.orElse("Quarkus123"));
                container.withPassword(effectivePassword).withReuse(containerConfig.isReuse());
                Labels.addDataSourceLabel((GenericContainer)container, (String)datasourceName);
                Volumes.addVolumes((GenericContainer)container, (Map)containerConfig.getVolumes());
                container.withEnv(containerConfig.getContainerEnv());
                containerConfig.getAdditionalJdbcUrlProperties().forEach((arg_0, arg_1) -> ((QuarkusMSSQLServerContainer)container).withUrlParam(arg_0, arg_1));
                containerConfig.getCommand().ifPresent(arg_0 -> ((QuarkusMSSQLServerContainer)container).setCommand(arg_0));
                containerConfig.getInitScriptPath().ifPresent(arg_0 -> ((QuarkusMSSQLServerContainer)container).withInitScript(arg_0));
                container.start();
                LOG.info((Object)"Dev Services for Microsoft SQL Server started.");
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getContainerId(), container.getEffectiveJdbcUrl(), container.getReactiveUrl(), MSSQLDevServicesProcessor.DEFAULT_USERNAME, container.getPassword(), (Closeable)new ContainerShutdownCloseable((GenericContainer)container, "Microsoft SQL Server"));
            }
        });
    }

    private static class QuarkusMSSQLServerContainer
    extends MSSQLServerContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusMSSQLServerContainer(Optional<String> imageName, OptionalInt fixedExposedPort, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName.orElseGet(() -> ConfigureUtil.getDefaultImageNameFor((String)"mssql"))).asCompatibleSubstituteFor(MSSQLServerContainer.IMAGE));
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"mssql");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), MSSQLServerContainer.MS_SQL_SERVER_PORT);
            } else {
                this.addExposedPort(MS_SQL_SERVER_PORT);
            }
        }

        public String getEffectiveJdbcUrl() {
            if (this.useSharedNetwork) {
                String additionalUrlParams = this.constructUrlParameters(";", ";");
                return "jdbc:sqlserver://" + this.hostName + ":" + MS_SQL_SERVER_PORT + additionalUrlParams;
            }
            return super.getJdbcUrl();
        }

        public String getReactiveUrl() {
            StringBuilder url = new StringBuilder("vertx-reactive:sqlserver://");
            if (this.useSharedNetwork) {
                url.append(this.hostName).append(":").append(MS_SQL_SERVER_PORT);
            } else {
                url.append(this.getHost()).append(":").append(this.getMappedPort(MS_SQL_SERVER_PORT));
            }
            return url.toString();
        }
    }
}

