/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.postgresql.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.utility.DockerImageName;

public class MySQLDevServicesProcessor {
    public static final String TAG = "8.0.24";

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupMysql() {
        return new DevServicesDatasourceProviderBuildItem("mysql", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, Optional<String> imageName, Map<String, String> additionalProperties, final OptionalInt fixedExposedPort) {
                final MySQLContainer container = new MySQLContainer(DockerImageName.parse((String)imageName.orElse(MySQLContainer.IMAGE + ":" + MySQLDevServicesProcessor.TAG)).asCompatibleSubstituteFor(DockerImageName.parse((String)MySQLContainer.IMAGE))){

                    protected void configure() {
                        super.configure();
                        if (fixedExposedPort.isPresent()) {
                            this.addFixedExposedPort(fixedExposedPort.getAsInt(), MySQLContainer.MYSQL_PORT);
                        }
                    }
                }.withPassword(password.orElse("quarkus")).withUsername(username.orElse("quarkus")).withDatabaseName(datasourceName.orElse("default"));
                additionalProperties.forEach((arg_0, arg_1) -> ((MySQLContainer)container).withUrlParam(arg_0, arg_1));
                container.start();
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getJdbcUrl(), container.getUsername(), container.getPassword(), new Closeable(){

                    @Override
                    public void close() throws IOException {
                        container.stop();
                    }
                });
            }
        });
    }
}

