/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.postgresql.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ConsoleCommandBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.devservices.postgresql.deployment.PostgresCommand;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.aesh.command.Command;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class PostgresqlDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(PostgresqlDevServicesProcessor.class);

    @BuildStep
    ConsoleCommandBuildItem psqlCommand(DevServicesLauncherConfigResultBuildItem devServices) {
        return new ConsoleCommandBuildItem((Command)new PostgresCommand(devServices));
    }

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupPostgres(final List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem) {
        return new DevServicesDatasourceProviderBuildItem("postgresql", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, DevServicesDatasourceContainerConfig containerConfig, LaunchMode launchMode, Optional<Duration> startupTimeout) {
                QuarkusPostgreSQLContainer container = new QuarkusPostgreSQLContainer(containerConfig.getImageName(), containerConfig.getFixedExposedPort(), !devServicesSharedNetworkBuildItem.isEmpty());
                startupTimeout.ifPresent(arg_0 -> ((QuarkusPostgreSQLContainer)container).withStartupTimeout(arg_0));
                container.withPassword(password.orElse("quarkus")).withUsername(username.orElse("quarkus")).withDatabaseName(datasourceName.orElse("default")).withReuse(true);
                containerConfig.getAdditionalJdbcUrlProperties().forEach((arg_0, arg_1) -> ((QuarkusPostgreSQLContainer)container).withUrlParam(arg_0, arg_1));
                containerConfig.getCommand().ifPresent(arg_0 -> ((QuarkusPostgreSQLContainer)container).setCommand(arg_0));
                container.start();
                LOG.info((Object)"Dev Services for PostgreSQL started.");
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getContainerId(), container.getEffectiveJdbcUrl(), container.getReactiveUrl(), container.getUsername(), container.getPassword(), (Closeable)new ContainerShutdownCloseable((GenericContainer)container, "PostgreSQL"));
            }
        });
    }

    private static class QuarkusPostgreSQLContainer
    extends PostgreSQLContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusPostgreSQLContainer(Optional<String> imageName, OptionalInt fixedExposedPort, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName.orElseGet(() -> ConfigureUtil.getDefaultImageNameFor((String)"postgresql"))).asCompatibleSubstituteFor(DockerImageName.parse((String)"postgres")));
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"postgres");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), PostgreSQLContainer.POSTGRESQL_PORT);
            } else {
                this.addExposedPort(POSTGRESQL_PORT);
            }
        }

        public String getEffectiveJdbcUrl() {
            if (this.useSharedNetwork) {
                String additionalUrlParams = this.constructUrlParameters("?", "&");
                return "jdbc:postgresql://" + this.hostName + ":" + POSTGRESQL_PORT + "/" + this.getDatabaseName() + additionalUrlParams;
            }
            return super.getJdbcUrl();
        }

        public String getReactiveUrl() {
            return this.getEffectiveJdbcUrl().replaceFirst("jdbc:", "vertx-reactive:");
        }
    }
}

