/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.maven.dependency.GACT;
import java.io.Serializable;
import java.util.Objects;

public class ArtifactKey
implements io.quarkus.maven.dependency.ArtifactKey,
Serializable {
    protected final String groupId;
    protected final String artifactId;
    protected final String classifier;
    protected final String type;

    public static ArtifactKey fromString(String str) {
        return new ArtifactKey(GACT.split((String)str, (String[])new String[4], (int)str.length()));
    }

    public ArtifactKey(String[] parts) {
        this.groupId = parts[0];
        this.artifactId = parts[1];
        this.classifier = parts.length == 2 || parts[2] == null ? "" : parts[2];
        this.type = parts.length <= 3 || parts[3] == null ? "jar" : parts[3];
    }

    public ArtifactKey(String groupId, String artifactId) {
        this(groupId, artifactId, null);
    }

    public ArtifactKey(String groupId, String artifactId, String classifier) {
        this(groupId, artifactId, classifier, null);
    }

    public ArtifactKey(String groupId, String artifactId, String classifier, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier == null ? "" : classifier;
        this.type = type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.classifier, this.groupId, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof io.quarkus.maven.dependency.ArtifactKey)) {
            return false;
        }
        io.quarkus.maven.dependency.ArtifactKey other = (io.quarkus.maven.dependency.ArtifactKey)obj;
        return Objects.equals(this.artifactId, other.getArtifactId()) && Objects.equals(this.classifier, other.getClassifier()) && Objects.equals(this.groupId, other.getGroupId()) && Objects.equals(this.type, other.getType());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId);
        if (!this.classifier.isEmpty()) {
            buf.append(':').append(this.classifier);
        } else if (this.type != null) {
            buf.append(':');
        }
        if (this.type != null) {
            buf.append(':').append(this.type);
        }
        return buf.toString();
    }
}

