/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.reader;

import io.quarkus.devtools.codestarts.reader.QuteCodestartFileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface CodestartFileReader {
    public static final CodestartFileReader DEFAULT = new DefaultCodestartFileReader();
    public static final CodestartFileReader QUTE = new QuteCodestartFileReader();
    public static final List<CodestartFileReader> ALL = Collections.unmodifiableList(Arrays.asList(DEFAULT, QUTE));

    public boolean matches(String var1);

    public String cleanFileName(String var1);

    public Optional<String> read(Path var1, Path var2, String var3, Map<String, Object> var4) throws IOException;

    public static class DefaultCodestartFileReader
    implements CodestartFileReader {
        @Override
        public boolean matches(String fileName) {
            return false;
        }

        @Override
        public String cleanFileName(String fileName) {
            return fileName.replace("..", ".");
        }

        @Override
        public Optional<String> read(Path sourceDirectory, Path relativeSourcePath, String languageName, Map<String, Object> data) throws IOException {
            return Optional.of(new String(Files.readAllBytes(sourceDirectory.resolve(relativeSourcePath)), StandardCharsets.UTF_8));
        }
    }
}

