/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartData;
import io.quarkus.devtools.codestarts.CodestartInput;
import io.quarkus.devtools.codestarts.CodestartSpec;
import io.quarkus.devtools.codestarts.NestedMaps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CodestartProject {
    private final List<Codestart> codestarts;
    private final CodestartInput codestartInput;

    CodestartProject(CodestartInput codestartInput, List<Codestart> codestarts) {
        this.codestartInput = Objects.requireNonNull(codestartInput, "codestartInput is required");
        this.codestarts = Objects.requireNonNull(codestarts, "codestarts is required");
        this.checkContainsType(CodestartSpec.Type.PROJECT);
        this.checkContainsType(CodestartSpec.Type.LANGUAGE);
    }

    public List<Codestart> getCodestarts() {
        return this.codestarts;
    }

    public CodestartInput getCodestartInput() {
        return this.codestartInput;
    }

    public Optional<Codestart> getCodestart(CodestartSpec.Type type) {
        return this.codestarts.stream().filter(c -> c.getType() == type).findFirst();
    }

    public Codestart getRequiredCodestart(CodestartSpec.Type type) {
        return this.checkContainsType(type);
    }

    public String getLanguageName() {
        return this.getRequiredCodestart(CodestartSpec.Type.LANGUAGE).getName();
    }

    public Map<String, Object> getSharedData() {
        Stream<Map> codestartsGlobal = this.getCodestarts().stream().map(c -> c.getSharedData(this.getLanguageName()));
        return NestedMaps.deepMerge(Stream.concat(codestartsGlobal, Stream.of(this.getCodestartInput().getData())));
    }

    public Map<String, Object> getDepsData() {
        return CodestartData.buildDependenciesData(this.getCodestarts().stream(), this.getLanguageName(), this.getCodestartInput().getExtensions());
    }

    public Map<String, Object> getCodestartProjectData() {
        return CodestartData.buildCodestartProjectData(this.getBaseCodestarts(), this.getExtraCodestarts());
    }

    List<Codestart> getBaseCodestarts() {
        return this.getCodestarts().stream().filter(c -> c.getSpec().getType().isBase()).collect(Collectors.toList());
    }

    List<Codestart> getExtraCodestarts() {
        return this.getCodestarts().stream().filter(c -> !c.getSpec().getType().isBase()).collect(Collectors.toList());
    }

    private Codestart checkContainsType(CodestartSpec.Type type) {
        return this.getCodestart(type).orElseThrow(() -> new IllegalArgumentException(type.toString().toLowerCase() + " Codestart is required"));
    }
}

