/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartData;
import io.quarkus.devtools.codestarts.CodestartDefinitionException;
import io.quarkus.devtools.codestarts.CodestartException;
import io.quarkus.devtools.codestarts.CodestartInput;
import io.quarkus.devtools.codestarts.CodestartLoader;
import io.quarkus.devtools.codestarts.CodestartProcessor;
import io.quarkus.devtools.codestarts.CodestartProject;
import io.quarkus.devtools.codestarts.CodestartSpec;
import io.quarkus.devtools.codestarts.NestedMaps;
import io.quarkus.devtools.codestarts.strategy.CodestartFileStrategy;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Codestarts {
    public static CodestartProject prepareProject(CodestartInput input) throws IOException {
        Optional<Object> buildtool = NestedMaps.getValue(input.getData(), CodestartData.DataKey.BUILDTOOL.getKey());
        Set<String> selectedCodestartNames = Stream.concat(input.getCodestarts().stream(), Stream.of(buildtool.orElse(null)).filter(Objects::nonNull)).collect(Collectors.toSet());
        List<Codestart> allCodestarts = CodestartLoader.loadAllCodestarts(input);
        Collection<Codestart> baseCodestarts = Codestarts.resolveSelectedBaseCodestarts(allCodestarts, selectedCodestartNames);
        String languageName = baseCodestarts.stream().filter(c -> c.getType() == CodestartSpec.Type.LANGUAGE).findFirst().orElseThrow(() -> new CodestartDefinitionException("Language codestart is required")).getName();
        Collection<Codestart> extraCodestarts = Codestarts.resolveSelectedExtraCodestarts(input, selectedCodestartNames, allCodestarts, languageName);
        ArrayList<Codestart> selectedCodestarts = new ArrayList<Codestart>();
        selectedCodestarts.addAll(baseCodestarts);
        selectedCodestarts.addAll(extraCodestarts);
        if (input.includeExamples() && extraCodestarts.stream().noneMatch(c -> c.getSpec().isExample() && !c.getSpec().isPreselected())) {
            List<Codestart> fallbackExampleCodestarts = Codestarts.resolveFallbackExampleCodestarts(allCodestarts, languageName);
            selectedCodestarts.addAll(fallbackExampleCodestarts);
        }
        return new CodestartProject(input, selectedCodestarts);
    }

    public static void generateProject(CodestartProject codestartProject, Path targetDirectory) throws IOException {
        String languageName = codestartProject.getLanguageName();
        Map<String, Object> data = NestedMaps.deepMerge(Stream.of(codestartProject.getSharedData(), codestartProject.getDepsData(), codestartProject.getCodestartProjectData()));
        Codestart projectCodestart = codestartProject.getRequiredCodestart(CodestartSpec.Type.PROJECT);
        List<CodestartFileStrategy> strategies = CodestartProcessor.buildStrategies(Codestarts.mergeStrategies(codestartProject));
        CodestartProcessor processor = new CodestartProcessor(codestartProject.getCodestartInput().getResourceLoader(), languageName, targetDirectory, strategies, data);
        processor.checkTargetDir();
        for (Codestart codestart : codestartProject.getCodestarts()) {
            processor.process(codestart);
        }
        processor.writeFiles();
    }

    private static Map<String, String> mergeStrategies(CodestartProject codestartProject) {
        return NestedMaps.deepMerge(codestartProject.getCodestarts().stream().map(Codestart::getSpec).map(CodestartSpec::getOutputStrategy));
    }

    private static Collection<Codestart> resolveSelectedExtraCodestarts(CodestartInput input, Set<String> selectedCodestartNames, Collection<Codestart> allCodestarts, String languageName) {
        return allCodestarts.stream().filter(c -> !c.getSpec().getType().isBase()).filter(c -> c.getSpec().isPreselected() || c.isSelected(selectedCodestartNames)).filter(c -> !c.getSpec().isExample() || input.includeExamples()).filter(c -> c.implementsLanguage(languageName)).collect(Collectors.toList());
    }

    private static Collection<Codestart> resolveSelectedBaseCodestarts(Collection<Codestart> allCodestarts, Set<String> selectedCodestartNames) {
        return allCodestarts.stream().filter(c -> c.getSpec().getType().isBase()).filter(c -> c.getSpec().isFallback() || c.isSelected(selectedCodestartNames)).collect(Collectors.toMap(c -> c.getSpec().getType(), c -> c, (a, b) -> {
            if (a.getSpec().isFallback() && b.getSpec().isFallback()) {
                throw new CodestartDefinitionException("Multiple fallback found for a base codestart of type: '" + (Object)((Object)a.getSpec().getType()) + "' that should be unique. Only one of '" + a.getSpec().getName() + "' and '" + b.getSpec().getName() + "' should be a fallback");
            }
            if (!a.getSpec().isFallback() && !b.getSpec().isFallback()) {
                throw new CodestartException("Multiple selection for base codestart of type: '" + (Object)((Object)a.getSpec().getType()) + "' that should be unique. Only one of '" + a.getSpec().getName() + "' and '" + b.getSpec().getName() + "' should be selected at once.");
            }
            return !a.getSpec().isFallback() ? a : b;
        })).values();
    }

    private static List<Codestart> resolveFallbackExampleCodestarts(List<Codestart> allCodestarts, String languageName) {
        return allCodestarts.stream().filter(c -> !c.getSpec().getType().isBase()).filter(c -> c.getSpec().isExample() && c.getSpec().isFallback()).filter(c -> c.implementsLanguage(languageName)).collect(Collectors.toList());
    }
}

