/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartSpec;
import io.quarkus.devtools.codestarts.NestedMaps;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CodestartData {
    private CodestartData() {
    }

    static Map<String, Object> buildCodestartData(Codestart codestart, String languageName, Map<String, Object> data) {
        return NestedMaps.deepMerge(Stream.of(codestart.getLocalData(languageName), data));
    }

    public static Map<String, Object> buildCodestartProjectData(Collection<Codestart> baseCodestarts, Collection<Codestart> extraCodestarts) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        baseCodestarts.forEach(c -> data.put("codestart-project." + c.getSpec().getType().toString().toLowerCase() + ".name", c.getName()));
        data.put("codestart-project.codestarts", extraCodestarts.stream().map(Codestart::getName).collect(Collectors.toList()));
        return NestedMaps.unflatten(data);
    }

    static Map<String, Object> buildDependenciesData(Stream<Codestart> codestartsStream, String languageName, Collection<AppArtifactKey> extensions) {
        HashMap depsData = new HashMap();
        Set extensionsAsDeps = extensions.stream().map(k -> k.getGroupId() + ":" + k.getArtifactId()).map(CodestartSpec.CodestartDep::new).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet dependencies = new LinkedHashSet(extensionsAsDeps);
        LinkedHashSet testDependencies = new LinkedHashSet();
        codestartsStream.flatMap(s -> Stream.of(s.getBaseLanguageSpec(), s.getLanguageSpec(languageName))).forEach(d -> {
            dependencies.addAll(d.getDependencies());
            testDependencies.addAll(d.getTestDependencies());
        });
        depsData.put("dependencies", dependencies);
        depsData.put("test-dependencies", testDependencies);
        return Collections.unmodifiableMap(depsData);
    }

    public static enum LegacySupport {
        BOM_GROUP_ID("bom_groupId"),
        BOM_ARTIFACT_ID("bom_artifactId"),
        BOM_VERSION("bom_version"),
        PROJECT_GROUP_ID("project_groupId"),
        PROJECT_ARTIFACT_ID("project_artifactId"),
        PROJECT_VERSION("project_version"),
        QUARKUS_PLUGIN_GROUP_ID("plugin_groupId"),
        QUARKUS_PLUGIN_ARTIFACT_ID("plugin_artifactId"),
        QUARKUS_PLUGIN_VERSION("plugin_version"),
        QUARKUS_VERSION("quarkus_version"),
        JAVA_VERSION("java_target");

        private final String legacyKey;
        private final String key = DataKey.valueOf(this.name()).getKey();

        private LegacySupport(String legacyKey) {
            this.legacyKey = legacyKey;
        }

        public String getKey() {
            return this.key;
        }

        public String getLegacyKey() {
            return this.legacyKey;
        }

        public static Map<String, Object> convertFromLegacy(Map<String, Object> legacy) {
            return NestedMaps.unflatten(Stream.of(LegacySupport.values()).filter(v -> v.getLegacyKey() != null).filter(v -> legacy.containsKey(v.getLegacyKey())).map(v -> new AbstractMap.SimpleImmutableEntry(v.getKey(), legacy.get(v.getLegacyKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
    }

    public static enum DataKey {
        BOM_GROUP_ID("quarkus.platform.group-id"),
        BOM_ARTIFACT_ID("quarkus.platform.artifact-id"),
        BOM_VERSION("quarkus.platform.version"),
        PROJECT_GROUP_ID("project.group-id"),
        PROJECT_ARTIFACT_ID("project.artifact-id"),
        PROJECT_VERSION("project.version"),
        QUARKUS_PLUGIN_GROUP_ID("quarkus.plugin.group-id"),
        QUARKUS_PLUGIN_ARTIFACT_ID("quarkus.plugin.artifact-id"),
        QUARKUS_PLUGIN_VERSION("quarkus.plugin.version"),
        QUARKUS_VERSION("quarkus.version"),
        BUILDTOOL("buildtool.name"),
        JAVA_VERSION("java.version");

        private final String key;

        private DataKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

