/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.strategy;

import io.quarkus.devtools.codestarts.CodestartDefinitionException;
import io.quarkus.devtools.codestarts.reader.CodestartFile;
import io.quarkus.devtools.codestarts.strategy.CodestartFileStrategyHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

final class ExecutableFileStrategyHandler
implements CodestartFileStrategyHandler {
    ExecutableFileStrategyHandler() {
    }

    @Override
    public String name() {
        return "executable";
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<CodestartFile> codestartFiles, Map<String, Object> data) throws IOException {
        this.checkNotEmptyCodestartFiles(codestartFiles);
        Path targetPath = targetDirectory.resolve(relativePath);
        this.checkTargetDoesNotExist(targetPath);
        if (codestartFiles.size() > 1) {
            throw new CodestartDefinitionException("Multiple files found for path with executable FileStrategy: " + relativePath);
        }
        Files.write(targetPath, codestartFiles.get(0).getContent().getBytes(), new OpenOption[0]);
        File file = targetPath.toFile();
        file.setExecutable(true, false);
        file.setReadable(true, false);
        file.setWritable(true, true);
    }
}

