/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.strategy;

import io.quarkus.devtools.codestarts.CodestartDefinitionException;
import io.quarkus.devtools.codestarts.reader.CodestartFile;
import io.quarkus.devtools.codestarts.strategy.CodestartFileStrategyHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

final class FailOnDuplicateCodestartFileStrategyHandler
implements CodestartFileStrategyHandler {
    FailOnDuplicateCodestartFileStrategyHandler() {
    }

    @Override
    public String name() {
        return "fail-on-duplicate";
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<CodestartFile> codestartFiles, Map<String, Object> data) throws IOException {
        this.checkNotEmptyCodestartFiles(codestartFiles);
        if (codestartFiles.size() > 1) {
            throw new CodestartDefinitionException("Multiple files found for path with 'fail-on-duplicate' FileStrategy: " + relativePath);
        }
        Path targetPath = targetDirectory.resolve(relativePath);
        this.checkTargetDoesNotExist(targetPath);
        Files.write(targetPath, codestartFiles.get(0).getContent().getBytes(), new OpenOption[0]);
    }
}

