/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartDefinitionException;
import io.quarkus.devtools.codestarts.CodestartInput;
import io.quarkus.devtools.codestarts.CodestartResourceLoader;
import io.quarkus.devtools.codestarts.CodestartSpec;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;

final class CodestartLoader {
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
    private static final String CODESTARTS_DIR_BUNDLED = "bundled-codestarts";
    private static final String CODESTARTS_DIR_FROM_EXTENSIONS = "codestarts";

    private CodestartLoader() {
    }

    public static List<Codestart> loadAllCodestarts(CodestartInput input) throws IOException {
        return CodestartLoader.loadAllCodestarts(input.getResourceLoader());
    }

    public static List<Codestart> loadAllCodestarts(CodestartResourceLoader resourceLoader) throws IOException {
        return Stream.concat(CodestartLoader.loadBundledCodestarts(resourceLoader).stream(), CodestartLoader.loadCodestartsFromExtensions(resourceLoader).stream()).collect(Collectors.toList());
    }

    public static Collection<Codestart> loadBundledCodestarts(CodestartInput input) throws IOException {
        return CodestartLoader.loadBundledCodestarts(input.getResourceLoader());
    }

    public static Collection<Codestart> loadBundledCodestarts(CodestartResourceLoader resourceLoader) throws IOException {
        return CodestartLoader.loadCodestarts(resourceLoader, CODESTARTS_DIR_BUNDLED);
    }

    public static Collection<Codestart> loadCodestartsFromExtensions(CodestartInput input) throws IOException {
        return CodestartLoader.loadCodestartsFromExtensions(input.getResourceLoader());
    }

    public static Collection<Codestart> loadCodestartsFromExtensions(CodestartResourceLoader resourceLoader) throws IOException {
        return CodestartLoader.loadCodestarts(resourceLoader, CODESTARTS_DIR_FROM_EXTENSIONS);
    }

    static Collection<Codestart> loadCodestarts(CodestartResourceLoader resourceLoader, String directoryName) throws IOException {
        return resourceLoader.loadResourceAsPath(directoryName, path -> {
            try (Stream<Path> pathStream = Files.walk(path, new FileVisitOption[0]);){
                List list = pathStream.filter(p -> p.getFileName().toString().matches("codestart\\.yml$")).map(p -> {
                    String resourceName = CodestartLoader.resolveResourceName(directoryName, path, p);
                    try {
                        CodestartSpec spec = CodestartLoader.readCodestartSpec(new String(Files.readAllBytes(p)));
                        String resourceCodestartDirectory = resourceName.replaceAll("/?codestart\\.yml", "");
                        return new Codestart(resourceCodestartDirectory, spec, CodestartLoader.resolveImplementedLanguages(p.getParent()));
                    }
                    catch (IOException e) {
                        throw new CodestartDefinitionException("Failed to load codestart spec: " + resourceName, e);
                    }
                }).collect(Collectors.toList());
                return list;
            }
        });
    }

    private static Set<String> resolveImplementedLanguages(Path p) throws IOException {
        try (Stream<Path> files = Files.list(p);){
            Set<String> set = files.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(d -> d.getFileName().toString().replaceAll("([/\\\\])$", "")).filter(l -> !Objects.equals(l, "base")).collect(Collectors.toSet());
            return set;
        }
    }

    static CodestartSpec readCodestartSpec(String content) throws JsonProcessingException {
        return (CodestartSpec)YAML_MAPPER.readerFor(CodestartSpec.class).readValue(content);
    }

    private static String resolveResourceName(String dirName, Path dirPath, Path resourcePath) {
        return FilenameUtils.concat((String)dirName, (String)dirPath.relativize(resourcePath).toString()).replace('\\', '/');
    }
}

