/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.devtools.codestarts.CodestartSpec;
import io.quarkus.devtools.codestarts.NestedMaps;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public final class Codestart {
    public static final String BASE_LANGUAGE = "base";
    private final String resourceDir;
    private final CodestartSpec spec;
    private final Set<String> implementedLanguages;

    public Codestart(String resourceName, CodestartSpec spec, Set<String> implementedLanguages) {
        this.resourceDir = resourceName;
        this.spec = spec;
        this.implementedLanguages = implementedLanguages;
    }

    public String getResourceDir() {
        return this.resourceDir;
    }

    public CodestartSpec getSpec() {
        return this.spec;
    }

    public String getName() {
        return this.spec.getName();
    }

    public String getRef() {
        return this.spec.getRef();
    }

    public int getTypeOrder() {
        return this.spec.getType().getOrder();
    }

    public boolean isSelected(Set<String> selection) {
        return selection.contains(this.getName()) || selection.contains(this.spec.getRef());
    }

    public CodestartSpec.Type getType() {
        return this.spec.getType();
    }

    public Set<String> getImplementedLanguages() {
        return this.implementedLanguages;
    }

    public boolean implementsLanguage(String languageName) {
        return this.implementedLanguages.isEmpty() || this.implementedLanguages.contains(languageName);
    }

    public boolean containsTag(String tag) {
        return this.getSpec().getTags().contains(tag);
    }

    public Map<String, Object> getLocalData(String languageName) {
        return NestedMaps.deepMerge(Stream.of(this.getBaseLanguageSpec().getData(), this.getLanguageSpec(languageName).getData()));
    }

    public Map<String, Object> getSharedData(String languageName) {
        return NestedMaps.deepMerge(Stream.of(this.getBaseLanguageSpec().getSharedData(), this.getLanguageSpec(languageName).getSharedData()));
    }

    public CodestartSpec.LanguageSpec getBaseLanguageSpec() {
        return this.getSpec().getLanguagesSpec().getOrDefault(BASE_LANGUAGE, new CodestartSpec.LanguageSpec());
    }

    public CodestartSpec.LanguageSpec getLanguageSpec(String languageName) {
        return this.getSpec().getLanguagesSpec().getOrDefault(languageName, new CodestartSpec.LanguageSpec());
    }
}

