/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.devtools.codestarts.CodestartInputBuilder;
import io.quarkus.devtools.codestarts.CodestartResourceLoader;
import io.quarkus.devtools.codestarts.NestedMaps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class CodestartInput {
    private final CodestartResourceLoader resourceLoader;
    private final Collection<AppArtifactKey> dependencies;
    private final Map<String, Object> data;
    private final Collection<String> codestarts;

    CodestartInput(CodestartInputBuilder builder) {
        this.resourceLoader = Objects.requireNonNull(builder.resourceLoader, "resourceLoader is required");
        this.dependencies = Objects.requireNonNull(builder.dependencies, "dependencies is required");
        this.codestarts = Objects.requireNonNull(builder.codestarts, "codestarts is required");
        this.data = NestedMaps.unflatten(Objects.requireNonNull(builder.data, "data is required"));
    }

    public static CodestartInputBuilder builder(CodestartResourceLoader resourceLoader) {
        return new CodestartInputBuilder(resourceLoader);
    }

    public CodestartResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Collection<String> getCodestarts() {
        return this.codestarts;
    }

    public Collection<AppArtifactKey> getDependencies() {
        return this.dependencies;
    }

    public Map<String, Object> getData() {
        return this.data;
    }
}

