/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.reader;

import io.quarkus.devtools.codestarts.CodestartException;
import io.quarkus.devtools.codestarts.reader.CodestartFileReader;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.Results;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.Variant;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

final class QuteCodestartFileReader
implements CodestartFileReader {
    private static final String FLAG = ".tpl.qute";
    public static final String INCLUDE_QUTE_FLAG = ".include.qute";

    QuteCodestartFileReader() {
    }

    @Override
    public boolean matches(String fileName) {
        return fileName.contains(FLAG) || fileName.contains(INCLUDE_QUTE_FLAG);
    }

    @Override
    public String cleanFileName(String fileName) {
        return fileName.replace(FLAG, "");
    }

    @Override
    public Optional<String> read(Path sourceDirectory, Path relativeSourcePath, String languageName, Map<String, Object> data) throws IOException {
        if (relativeSourcePath.getFileName().toString().contains(INCLUDE_QUTE_FLAG)) {
            return Optional.empty();
        }
        return Optional.of(QuteCodestartFileReader.readQuteFile(sourceDirectory, relativeSourcePath, languageName, data));
    }

    public static String readQuteFile(Path sourceDirectory, Path relativeSourcePath, String languageName, Map<String, Object> data) throws IOException {
        Path sourcePath = sourceDirectory.resolve(relativeSourcePath);
        String content = new String(Files.readAllBytes(sourcePath), StandardCharsets.UTF_8);
        Engine engine = Engine.builder().addDefaults().addResultMapper((ResultMapper)new MissingValueMapper()).removeStandaloneLines(true).addLocator(id -> QuteCodestartFileReader.findIncludeTemplate(sourceDirectory, languageName, id).map(x$0 -> new IncludeTemplateLocation((Path)x$0))).build();
        try {
            return engine.parse(content).render(data);
        }
        catch (TemplateException e) {
            throw new CodestartException("Error while rendering template: " + sourcePath.toString(), e);
        }
    }

    private static Optional<Path> findIncludeTemplate(Path sourceDirectory, String languageName, String name) {
        Path codestartPath = sourceDirectory.getParent();
        String includeFileName = name + INCLUDE_QUTE_FLAG;
        Path languageIncludeTemplate = codestartPath.resolve(languageName + "/" + includeFileName);
        if (Files.isRegularFile(languageIncludeTemplate, new LinkOption[0])) {
            return Optional.of(languageIncludeTemplate);
        }
        Path baseIncludeTemplate = codestartPath.resolve("base/" + includeFileName);
        if (Files.isRegularFile(baseIncludeTemplate, new LinkOption[0])) {
            return Optional.of(baseIncludeTemplate);
        }
        return Optional.empty();
    }

    static class MissingValueMapper
    implements ResultMapper {
        MissingValueMapper() {
        }

        public boolean appliesTo(TemplateNode.Origin origin, Object result) {
            return Results.Result.NOT_FOUND.equals(result);
        }

        public String map(Object result, Expression expression) {
            throw new TemplateException("Missing required data: {" + expression.toOriginalString() + "}");
        }
    }

    private static class IncludeTemplateLocation
    implements TemplateLocator.TemplateLocation {
        private final Path path;

        private IncludeTemplateLocation(Path path) {
            this.path = path;
        }

        public Reader read() {
            try {
                return Files.newBufferedReader(this.path);
            }
            catch (IOException e) {
                return null;
            }
        }

        public Optional<Variant> getVariant() {
            return Optional.empty();
        }
    }
}

