/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.strategy;

import io.quarkus.devtools.codestarts.strategy.CodestartFileStrategyHandler;
import java.util.Objects;
import java.util.function.Predicate;

public class CodestartFileStrategy
implements Predicate<String> {
    private final String filter;
    private final CodestartFileStrategyHandler handler;

    public CodestartFileStrategy(String filter, CodestartFileStrategyHandler handler) {
        this.filter = Objects.requireNonNull(filter, "filter is required");
        this.handler = Objects.requireNonNull(handler, "handler is required");
    }

    public String getFilter() {
        return this.filter;
    }

    @Override
    public boolean test(String t) {
        if (t == null) {
            return false;
        }
        if (this.filter.startsWith("*") && this.filter.length() > 1 && t.endsWith(this.filter.substring(1))) {
            return true;
        }
        if (this.filter.endsWith("*") && this.filter.length() > 1 && t.startsWith(this.filter.substring(0, this.filter.length() - 1))) {
            return true;
        }
        return this.filter.equals(t);
    }

    public CodestartFileStrategyHandler getHandler() {
        return this.handler;
    }
}

