/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core.strategy;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.quarkus.devtools.codestarts.CodestartException;
import io.quarkus.devtools.codestarts.core.reader.TargetFile;
import io.quarkus.devtools.codestarts.core.strategy.CodestartFileStrategyHandler;
import io.quarkus.devtools.codestarts.utils.NestedMaps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class SmartConfigMergeCodestartFileStrategyHandler
implements CodestartFileStrategyHandler {
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory().configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false));

    SmartConfigMergeCodestartFileStrategyHandler() {
    }

    @Override
    public String name() {
        return "smart-config-merge";
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<TargetFile> codestartFiles, Map<String, Object> data) throws IOException {
        this.checkNotEmptyCodestartFiles(codestartFiles);
        String configType = SmartConfigMergeCodestartFileStrategyHandler.getConfigType(data);
        HashMap<String, Object> config = new HashMap<String, Object>();
        for (TargetFile codestartFile : codestartFiles) {
            String content = codestartFile.getContent();
            if (content.trim().isEmpty()) continue;
            Map o = (Map)YAML_MAPPER.readerFor(Map.class).readValue(content);
            NestedMaps.deepMerge(config, o);
        }
        Path targetPath = targetDirectory.resolve(relativePath);
        this.createDirectories(targetPath);
        if (Objects.equals(configType, "config-properties")) {
            this.writePropertiesConfig(targetPath, config);
            return;
        }
        if (Objects.equals(configType, "config-yaml")) {
            this.writeYamlConfig(targetPath, config);
            return;
        }
        throw new CodestartException("Unsupported config type: " + configType);
    }

    private void writeYamlConfig(Path targetPath, Map<String, Object> config) throws IOException {
        this.checkTargetDoesNotExist(targetPath);
        YAML_MAPPER.writerFor(Map.class).writeValue(targetPath.toFile(), config);
    }

    private void writePropertiesConfig(Path targetPath, Map<String, Object> config) throws IOException {
        StringBuilder builder = new StringBuilder();
        HashMap<String, String> flat = new HashMap<String, String>();
        SmartConfigMergeCodestartFileStrategyHandler.flatten("", flat, config);
        for (Map.Entry<String, String> entry : flat.entrySet()) {
            builder.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        Path propertiesTargetPath = targetPath.getParent().resolve(targetPath.getFileName().toString().replace(".yml", ".properties"));
        this.checkTargetDoesNotExist(propertiesTargetPath);
        this.writeFile(propertiesTargetPath, builder.toString());
    }

    private static void flatten(String prefix, Map<String, String> target, Map<String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                SmartConfigMergeCodestartFileStrategyHandler.flatten(entry.getKey() + ".", target, (Map)entry.getValue());
                continue;
            }
            target.put(prefix + entry.getKey(), entry.getValue().toString());
        }
    }

    private static String getConfigType(Map<String, Object> data) {
        Optional config = NestedMaps.getValue(data, "codestart-project.config.name");
        return (String)config.orElseThrow(() -> new CodestartException("Config type is required"));
    }
}

