/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.devtools.codestarts.CodestartResource;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.core.CodestartSpec;
import io.quarkus.devtools.codestarts.utils.NestedMaps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

public final class Codestart {
    public static final String BASE_LANGUAGE = "base";
    private final CodestartResourceAllocator readerProvider;
    private final CodestartSpec spec;
    private final Set<String> implementedLanguages;

    public Codestart(CodestartResourceAllocator readerProvider, CodestartSpec spec, Set<String> implementedLanguages) {
        this.readerProvider = readerProvider;
        this.spec = spec;
        this.implementedLanguages = implementedLanguages;
    }

    public void use(Consumer<CodestartResource> readerConsumer) {
        this.readerProvider.allocate(readerConsumer);
    }

    public CodestartSpec getSpec() {
        return this.spec;
    }

    public String getName() {
        return this.spec.getName();
    }

    public Set<String> getTags() {
        return this.spec.getTags();
    }

    public Map<String, String> getMetadata() {
        return this.spec.getMetadata();
    }

    public String getRef() {
        return this.spec.getRef();
    }

    public int getTypeOrder() {
        return this.spec.getType().getProcessingOrder();
    }

    public boolean matches(String name) {
        return Objects.equals(this.spec.getName(), name) || Objects.equals(this.spec.getRef(), name);
    }

    public boolean isSelected(Set<String> selection) {
        return selection.contains(this.getName()) || selection.contains(this.spec.getRef());
    }

    public CodestartType getType() {
        return this.spec.getType();
    }

    public Set<String> getImplementedLanguages() {
        return this.implementedLanguages;
    }

    public boolean implementsLanguage(String languageName) {
        return this.implementedLanguages.isEmpty() || this.implementedLanguages.contains(languageName);
    }

    public boolean containsTag(String tag) {
        return this.getSpec().getTags().contains(tag);
    }

    public Map<String, Object> getLocalData(String languageName) {
        return NestedMaps.deepMerge(Stream.of(new HashMap<String, String>(this.getMetadata()), this.getBaseLanguageSpec().getData(), this.getLanguageSpec(languageName).getData()));
    }

    public Map<String, Object> getSharedData(String languageName) {
        return NestedMaps.deepMerge(Stream.of(this.getBaseLanguageSpec().getSharedData(), this.getLanguageSpec(languageName).getSharedData()));
    }

    public CodestartSpec.LanguageSpec getBaseLanguageSpec() {
        return this.getSpec().getLanguagesSpec().getOrDefault(BASE_LANGUAGE, new CodestartSpec.LanguageSpec());
    }

    public CodestartSpec.LanguageSpec getLanguageSpec(String languageName) {
        return this.getSpec().getLanguagesSpec().getOrDefault(languageName, new CodestartSpec.LanguageSpec());
    }

    public static interface CodestartResourceAllocator {
        public void allocate(Consumer<CodestartResource> var1);
    }
}

