/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core.strategy;

import io.quarkus.devtools.codestarts.CodestartStructureException;
import io.quarkus.devtools.codestarts.core.CodestartData;
import io.quarkus.devtools.codestarts.core.reader.TargetFile;
import io.quarkus.devtools.codestarts.core.strategy.CodestartFileStrategyHandler;
import io.quarkus.devtools.codestarts.utils.NestedMaps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class SmartPackageFileStrategyHandler
implements CodestartFileStrategyHandler {
    private static final String DEFAULT_PACKAGE_DIR = "org/acme";
    private static final String REPLACE_REGEX = "((import)|(package)) org\\.acme";

    SmartPackageFileStrategyHandler() {
    }

    @Override
    public String name() {
        return "smart-package";
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<TargetFile> codestartFiles, Map<String, Object> data) throws IOException {
        Path targetPath;
        boolean isMaven;
        this.checkNotEmptyCodestartFiles(codestartFiles);
        Optional optPackageName = NestedMaps.getValue(data, "project.package-name");
        String modifiedRelativePath = relativePath;
        String content = codestartFiles.get(0).getContent();
        if (optPackageName.isPresent()) {
            String packageName = (String)optPackageName.get();
            String packageNameAsDir = packageName.replace(".", "/");
            modifiedRelativePath = relativePath.replace(DEFAULT_PACKAGE_DIR, packageNameAsDir);
            content = SmartPackageFileStrategyHandler.refactorPackage(content, packageName);
        }
        if (modifiedRelativePath.contains("/native-test/") && (isMaven = CodestartData.getBuildtool(data).filter(b -> Objects.equals(b, "maven")).isPresent())) {
            modifiedRelativePath = modifiedRelativePath.replace("/native-test/", "/test/");
        }
        if (Files.exists(targetPath = targetDirectory.resolve(modifiedRelativePath), new LinkOption[0])) {
            throw new CodestartStructureException("File already exists: " + targetPath.toString());
        }
        this.createDirectories(targetPath);
        this.writeFile(targetPath, content);
    }

    static String refactorPackage(String content, String packageName) {
        return content.replaceAll(REPLACE_REGEX, "$1 " + packageName);
    }
}

