/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.templates.SourceType;
import io.quarkus.templates.TemplateRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;

public class CreateProject {
    private File root;
    private String groupId;
    private String artifactId;
    private String version = MojoUtils.getPluginVersion();
    private SourceType sourceType = SourceType.JAVA;
    private String className;
    private Model model;

    public CreateProject(File file) {
        this.root = file;
    }

    public CreateProject groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public CreateProject artifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public CreateProject version(String version) {
        this.version = version;
        return this;
    }

    public CreateProject sourceType(SourceType sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public CreateProject className(String className) {
        this.className = className;
        return this;
    }

    public Model getModel() {
        return this.model;
    }

    public boolean doCreateProject(Map<String, Object> context) throws IOException {
        boolean mkdirStatus;
        if (this.root.exists() && !this.root.isDirectory()) {
            System.out.println("Project root needs to either not exist or be a directory");
            return false;
        }
        if (!this.root.exists() && !(mkdirStatus = this.root.mkdirs())) {
            System.out.println("Failed to create root directory");
            return false;
        }
        System.out.println("Creating a new project in " + this.root.getAbsolutePath());
        MojoUtils.getAllProperties().forEach((k, v) -> context.put(k.replace("-", "_"), v));
        context.put("project_groupId", this.groupId);
        context.put("project_artifactId", this.artifactId);
        context.put("project_version", this.version);
        context.put("quarkus_version", MojoUtils.getPluginVersion());
        context.put("source_type", (Object)this.sourceType);
        if (this.className != null) {
            this.className = this.sourceType.stripExtensionFrom(this.className);
            int idx = this.className.lastIndexOf(46);
            if (idx >= 0) {
                String packageName = this.className.substring(0, idx);
                this.className = this.className.substring(idx + 1);
                context.put("package_name", packageName);
            }
            context.put("class_name", this.className);
        }
        TemplateRegistry.createTemplateWith("basic-rest").generate(this.root, context);
        File pom = new File(this.root + "/pom.xml");
        this.model = MojoUtils.readPom(pom);
        this.addVersionProperty(this.model);
        this.addBom(this.model);
        this.addMainPluginConfig(this.model);
        this.addNativeProfile(this.model);
        MojoUtils.write(this.model, pom);
        return true;
    }

    private void addBom(Model model) {
        boolean hasBom = false;
        DependencyManagement dm = model.getDependencyManagement();
        if (dm == null) {
            dm = new DependencyManagement();
            model.setDependencyManagement(dm);
        } else {
            hasBom = dm.getDependencies().stream().anyMatch(d -> d.getGroupId().equals(MojoUtils.getPluginGroupId()) && d.getArtifactId().equals(MojoUtils.getBomArtifactId()));
        }
        if (!hasBom) {
            Dependency bom = new Dependency();
            bom.setGroupId(MojoUtils.getPluginGroupId());
            bom.setArtifactId(MojoUtils.getBomArtifactId());
            bom.setVersion("${quarkus.version}");
            bom.setType("pom");
            bom.setScope("import");
            dm.addDependency(bom);
        }
    }

    private void addNativeProfile(Model model) {
        boolean match = model.getProfiles().stream().anyMatch(p -> p.getId().equals("native"));
        if (!match) {
            PluginExecution exec = new PluginExecution();
            exec.addGoal("native-image");
            exec.setConfiguration((Object)MojoUtils.configuration(new MojoUtils.Element("enableHttpUrlHandler", "true", new MojoUtils.Element[0])));
            Plugin plg = MojoUtils.plugin(MojoUtils.getPluginGroupId(), MojoUtils.getPluginArtifactId(), "${quarkus.version}");
            plg.addExecution(exec);
            BuildBase buildBase = new BuildBase();
            buildBase.addPlugin(plg);
            Profile profile = new Profile();
            profile.setId("native");
            profile.setBuild(buildBase);
            Activation activation = new Activation();
            ActivationProperty property = new ActivationProperty();
            property.setName("native");
            activation.setProperty(property);
            profile.setActivation(activation);
            model.addProfile(profile);
        }
    }

    private void addMainPluginConfig(Model model) {
        if (!this.hasPlugin(model)) {
            Plugin plugin = MojoUtils.plugin(MojoUtils.getPluginGroupId(), MojoUtils.getPluginArtifactId(), "${quarkus.version}");
            if (this.isParentPom(model)) {
                this.addPluginManagementSection(model, plugin);
                plugin = MojoUtils.plugin(MojoUtils.getPluginGroupId(), MojoUtils.getPluginArtifactId());
            }
            PluginExecution pluginExec = new PluginExecution();
            pluginExec.addGoal("build");
            plugin.addExecution(pluginExec);
            Build build = this.createBuildSectionIfRequired(model);
            build.getPlugins().add(plugin);
        }
    }

    private boolean hasPlugin(Model model) {
        List plugins = null;
        if (this.isParentPom(model)) {
            PluginManagement management = model.getBuild().getPluginManagement();
            if (management != null) {
                plugins = management.getPlugins();
            }
        } else {
            Build build = model.getBuild();
            if (build != null) {
                plugins = build.getPlugins();
            }
        }
        return plugins != null && model.getBuild().getPlugins().stream().anyMatch(p -> p.getGroupId().equalsIgnoreCase(MojoUtils.getPluginGroupId()) && p.getArtifactId().equalsIgnoreCase(MojoUtils.getPluginArtifactId()));
    }

    private void addPluginManagementSection(Model model, Plugin plugin) {
        if (model.getBuild().getPluginManagement() != null) {
            if (model.getBuild().getPluginManagement().getPlugins() == null) {
                model.getBuild().getPluginManagement().setPlugins(new ArrayList());
            }
            model.getBuild().getPluginManagement().getPlugins().add(plugin);
        }
    }

    private Build createBuildSectionIfRequired(Model model) {
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        if (build.getPlugins() == null) {
            build.setPlugins(new ArrayList());
        }
        return build;
    }

    private void addVersionProperty(Model model) {
        Properties properties = model.getProperties();
        if (properties == null) {
            properties = new Properties();
            model.setProperties(properties);
        }
        properties.putIfAbsent("quarkus.version", MojoUtils.getPluginVersion());
    }

    private boolean isParentPom(Model model) {
        return "pom".equals(model.getPackaging());
    }
}

