/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.dependencies.Extension;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.maven.utilities.QuarkusDependencyPredicate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;

public class ListExtensions {
    private static final String FORMAT = "%-8s %-20s %-50s %s";
    private Model model;

    public ListExtensions(Model model) {
        this.model = model;
    }

    public void listExtensions() {
        System.out.println("\nCurrent Quarkus extensions available: ");
        System.out.println(String.format(FORMAT, "Status", "Extension", "ArtifactId", "Updated Version"));
        Map<String, Dependency> installed = this.findInstalled();
        MojoUtils.loadExtensions().forEach(extension -> this.display((Extension)extension, installed));
    }

    private void display(Extension extension, Map<String, Dependency> installed) {
        Dependency dependency = installed.get(String.format("%s:%s", extension.getGroupId(), extension.getArtifactId()));
        String label = "";
        String version = "";
        String extracted = this.extractVersion(dependency);
        if (extracted != null) {
            if (MojoUtils.getPluginVersion().equalsIgnoreCase(extracted)) {
                label = "current";
            } else {
                label = "update";
                version = String.format("%s <> %s", extracted, MojoUtils.getPluginVersion());
            }
        }
        System.out.println(String.format(FORMAT, label, extension.getName(), extension.getArtifactId(), version));
    }

    private String extractVersion(Dependency dependency) {
        String value;
        String version;
        String string = version = dependency != null ? dependency.getVersion() : null;
        if (version != null && version.startsWith("$") && (value = (String)this.model.getProperties().get(this.propertyName(version))) != null) {
            version = value;
        }
        return version;
    }

    private String propertyName(String variable) {
        return variable.substring(2, variable.length() - 1);
    }

    Map<String, Dependency> findInstalled() {
        return this.mapDependencies(this.model.getDependencies(), this.loadManaged());
    }

    private Map<String, Dependency> loadManaged() {
        DependencyManagement managed = this.model.getDependencyManagement();
        return managed != null ? this.mapDependencies(managed.getDependencies(), Collections.emptyMap()) : Collections.emptyMap();
    }

    private Map<String, Dependency> mapDependencies(List<Dependency> dependencies, Map<String, Dependency> managed) {
        TreeMap<String, Dependency> map = new TreeMap<String, Dependency>();
        if (dependencies != null) {
            List<Dependency> listed = dependencies.stream().filter(new QuarkusDependencyPredicate()).collect(Collectors.toList());
            listed.forEach(d -> {
                String version;
                Dependency managedDep;
                if (d.getVersion() == null && (managedDep = (Dependency)managed.get(MojoUtils.credentials(d))) != null && (version = managedDep.getVersion()) != null) {
                    d.setVersion(version);
                }
                map.put(MojoUtils.credentials(d), (Dependency)d);
            });
        }
        return map;
    }
}

