/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.utilities;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.dependencies.Extension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MojoUtils {
    public static final String JAVA_EXTENSION = ".java";
    public static final String KOTLIN_EXTENSION = ".kt";
    private static final String PLUGIN_VERSION_PROPERTY_NAME = "quarkus.version";
    public static final String QUARKUS_VERSION_PROPERTY = "${quarkus.version}";
    private static final Properties properties = new Properties();

    private MojoUtils() {
    }

    public static Map<String, String> getAllProperties() {
        HashMap<String, String> all = new HashMap<String, String>();
        properties.stringPropertyNames().forEach(s -> all.put((String)s, properties.getProperty((String)s)));
        return all;
    }

    public static String getPluginArtifactId() {
        return MojoUtils.get("plugin-artifactId");
    }

    public static String getPluginGroupId() {
        return MojoUtils.get("plugin-groupId");
    }

    public static String getPluginVersion() {
        return MojoUtils.get("plugin-version");
    }

    public static String getBomArtifactId() {
        return MojoUtils.get("bom-artifactId");
    }

    public static String getProposedMavenVersion() {
        return MojoUtils.get("proposed-maven-version");
    }

    public static String getMavenWrapperVersion() {
        return MojoUtils.get("maven-wrapper-version");
    }

    private static void loadProperties() {
        URL url = MojoUtils.class.getClassLoader().getResource("quarkus.properties");
        Objects.requireNonNull(url);
        try (InputStream in = url.openStream();){
            properties.load(in);
        }
        catch (IOException e) {
            throw new IllegalStateException("The quarkus.properties file cannot be read", e);
        }
    }

    public static String get(String key) {
        return properties.getProperty(key);
    }

    public static Optional<Plugin> hasPlugin(MavenProject project, String pluginKey) {
        Optional<Plugin> optPlugin = project.getBuildPlugins().stream().filter(plugin -> pluginKey.equals(plugin.getKey())).findFirst();
        if (!optPlugin.isPresent() && project.getPluginManagement() != null) {
            optPlugin = project.getPluginManagement().getPlugins().stream().filter(plugin -> pluginKey.equals(plugin.getKey())).findFirst();
        }
        return optPlugin;
    }

    public static boolean hasDependency(Model model, String groupId, String artifactId) {
        return model.getDependencies().stream().anyMatch(d -> groupId.equals(d.getGroupId()) && artifactId.equals(d.getArtifactId()));
    }

    public static Dependency parse(String dependency) {
        Dependency res = new Dependency();
        String[] segments = dependency.split(":");
        if (segments.length >= 2) {
            res.setGroupId(segments[0]);
            res.setArtifactId(segments[1]);
            if (segments.length >= 3 && !segments[2].isEmpty()) {
                res.setVersion(segments[2]);
            }
            if (segments.length >= 4) {
                res.setClassifier(segments[3]);
            }
            return res;
        }
        throw new IllegalArgumentException("Invalid dependency description '" + dependency + "'");
    }

    public static Xpp3Dom configuration(Element ... elements) {
        Xpp3Dom dom = new Xpp3Dom("configuration");
        for (Element e : elements) {
            dom.addChild(e.toDom());
        }
        return dom;
    }

    public static Plugin plugin(String groupId, String artifactId) {
        return MojoUtils.plugin(groupId, artifactId, null);
    }

    public static Plugin plugin(String groupId, String artifactId, String version) {
        return MojoUtils.plugin(groupId, artifactId, version, Collections.emptyList());
    }

    public static Plugin plugin(String groupId, String artifactId, String version, List<Dependency> dependencies) {
        Plugin plugin = new Plugin();
        plugin.setArtifactId(artifactId);
        plugin.setGroupId(groupId);
        plugin.setVersion(version);
        plugin.setDependencies(dependencies);
        return plugin;
    }

    public static Model readPom(File pom) throws IOException {
        return MojoUtils.readPom(new FileInputStream(pom));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Model readPom(InputStream resourceAsStream) throws IOException {
        try (InputStream stream = resourceAsStream;){
            Model model = new MavenXpp3Reader().read(stream);
            return model;
        }
        catch (XmlPullParserException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static void write(Model model, File outputFile) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(outputFile);){
            new MavenXpp3Writer().write((OutputStream)stream, model);
        }
    }

    public static List<Extension> loadExtensions() {
        try {
            ObjectMapper mapper = new ObjectMapper().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS});
            List extensions = (List)mapper.readValue(MojoUtils.class.getClassLoader().getResourceAsStream("extensions.json"), (TypeReference)new TypeReference<List<Extension>>(){});
            extensions.forEach(e -> e.setVersion(QUARKUS_VERSION_PROPERTY));
            return extensions;
        }
        catch (IOException e2) {
            throw new RuntimeException("Unable to load the extensions.json file", e2);
        }
    }

    public static String credentials(Dependency d) {
        return String.format("%s:%s", d.getGroupId(), d.getArtifactId());
    }

    public static boolean checkProjectForMavenBuildPlugin(MavenProject project) {
        for (Plugin plugin : project.getBuildPlugins()) {
            if (!plugin.getGroupId().equals(MojoUtils.getPluginGroupId()) || !plugin.getArtifactId().equals(MojoUtils.getPluginArtifactId())) continue;
            for (PluginExecution pluginExecution : plugin.getExecutions()) {
                if (!pluginExecution.getGoals().contains("build")) continue;
                return true;
            }
        }
        return false;
    }

    static {
        MojoUtils.loadProperties();
    }

    public static class Attribute {
        private final String name;
        private final String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class Attributes {
        private List<Attribute> attributes;

        public Attributes(Attribute ... attributes) {
            this.attributes = Arrays.asList(attributes);
        }
    }

    public static class Element {
        private final Element[] children;
        private final String name;
        private final String text;
        private final Attributes attributes;

        public Element(String name, Element ... children) {
            this(name, null, new Attributes(new Attribute[0]), children);
        }

        public Element(String name, Attributes attributes, Element ... children) {
            this(name, null, attributes, children);
        }

        public Element(String name, String text, Element ... children) {
            this.name = name;
            this.text = text;
            this.children = children;
            this.attributes = new Attributes(new Attribute[0]);
        }

        public Element(String name, String text, Attributes attributes, Element ... children) {
            this.name = name;
            this.text = text;
            this.children = children;
            this.attributes = attributes;
        }

        public Xpp3Dom toDom() {
            Xpp3Dom dom = new Xpp3Dom(this.name);
            if (this.text != null) {
                dom.setValue(this.text);
            }
            for (Element e : this.children) {
                dom.addChild(e.toDom());
            }
            for (Attribute attribute : this.attributes.attributes) {
                dom.setAttribute(attribute.name, attribute.value);
            }
            return dom;
        }
    }
}

