/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.AddExtensionResult;
import io.quarkus.cli.commands.SelectionResult;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.dependencies.Extension;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;

public class AddExtensions {
    private static final String OK = "\u2705";
    private static final String NOK = "\u274c";
    private static final String NOOP = "\ud83d\udc4d";
    private Model model;
    private String pom;
    private ProjectWriter writer;

    public AddExtensions(ProjectWriter writer, String pom) throws IOException {
        this.model = MojoUtils.readPom(new ByteArrayInputStream(writer.getContent(pom)));
        this.writer = writer;
        this.pom = pom;
    }

    static SelectionResult select(String query, List<Extension> extensions, boolean labelLookup) {
        String q = query.trim().toLowerCase();
        Set<Extension> matchesNameOrArtifactId = extensions.stream().filter(extension -> extension.getName().equalsIgnoreCase(q) || AddExtensions.matchesArtifactId(extension.getArtifactId(), q)).collect(Collectors.toSet());
        if (matchesNameOrArtifactId.size() == 1) {
            return new SelectionResult(matchesNameOrArtifactId, true);
        }
        Set<Extension> matchesShortName = extensions.stream().filter(extension -> AddExtensions.matchesShortName(extension, q)).collect(Collectors.toSet());
        if (matchesShortName.size() == 1 && matchesNameOrArtifactId.isEmpty()) {
            return new SelectionResult(matchesShortName, true);
        }
        Set<Extension> partialMatches = extensions.stream().filter(extension -> extension.getName().toLowerCase().contains(q) || extension.getArtifactId().toLowerCase().contains(q) || extension.getShortName().toLowerCase().contains(q)).collect(Collectors.toSet());
        if (partialMatches.size() == 1 && matchesNameOrArtifactId.isEmpty() && matchesShortName.isEmpty()) {
            return new SelectionResult(partialMatches, true);
        }
        List<Object> matchesLabels = labelLookup ? extensions.stream().filter(extension -> extension.labels().contains(q)).collect(Collectors.toList()) : new ArrayList();
        LinkedHashSet<Extension> candidates = new LinkedHashSet<Extension>();
        candidates.addAll(matchesNameOrArtifactId);
        candidates.addAll(matchesShortName);
        candidates.addAll(partialMatches);
        candidates.addAll(matchesLabels);
        return new SelectionResult(candidates, false);
    }

    private static boolean matchesShortName(Extension extension, String q) {
        return q.equalsIgnoreCase(extension.getShortName());
    }

    private static boolean matchesArtifactId(String artifactId, String q) {
        return artifactId.equalsIgnoreCase(q) || artifactId.equalsIgnoreCase("quarkus-" + q);
    }

    public AddExtensionResult addExtensions(Set<String> extensions) throws IOException {
        if (extensions == null || extensions.isEmpty()) {
            return new AddExtensionResult(false, true);
        }
        boolean updated = false;
        boolean success = true;
        List<Dependency> dependenciesFromBom = this.getDependenciesFromBom();
        List<Extension> registry = MojoUtils.loadExtensions();
        for (String query : extensions) {
            if (query.contains(":")) {
                updated = this.addExtensionAsGAV(query) || updated;
                continue;
            }
            SelectionResult result = AddExtensions.select(query, registry, false);
            if (!result.matches()) {
                StringBuilder sb = new StringBuilder();
                Set<Extension> candidates = result.getExtensions();
                if (candidates.isEmpty()) {
                    this.print("\u274c Cannot find a dependency matching '" + query + "', maybe a typo?");
                    success = false;
                    continue;
                }
                sb.append(NOK).append(" Multiple extensions matching '").append(query).append("'");
                result.getExtensions().forEach(extension -> sb.append(System.lineSeparator()).append("     * ").append(extension.managementKey()));
                sb.append(System.lineSeparator()).append("     Be more specific e.g using the exact name or the full GAV.");
                this.print(sb.toString());
                success = false;
                continue;
            }
            Extension extension2 = result.getMatch();
            updated = this.addDependency(dependenciesFromBom, extension2) || updated;
        }
        if (updated) {
            ByteArrayOutputStream pomOutputStream = new ByteArrayOutputStream();
            MojoUtils.write(this.model, pomOutputStream);
            this.writer.write(this.pom, pomOutputStream.toString("UTF-8"));
        }
        return new AddExtensionResult(updated, success);
    }

    private boolean addDependency(List<Dependency> dependenciesFromBom, Extension extension) {
        if (!MojoUtils.hasDependency(this.model, extension.getGroupId(), extension.getArtifactId())) {
            this.print("\u2705 Adding extension " + extension.managementKey());
            this.model.addDependency(extension.toDependency(this.containsBOM(this.model) && this.isDefinedInBom(dependenciesFromBom, extension)));
            return true;
        }
        this.print("\ud83d\udc4d Skipping extension " + extension.managementKey() + ": already present");
        return false;
    }

    private boolean addExtensionAsGAV(String query) {
        Dependency parsed = MojoUtils.parse(query.trim().toLowerCase());
        boolean alreadyThere = this.model.getDependencies().stream().anyMatch(d -> d.getManagementKey().equalsIgnoreCase(parsed.getManagementKey()));
        if (!alreadyThere) {
            this.print("\u2705 Adding dependency " + parsed.getManagementKey());
            this.model.addDependency(parsed);
            return true;
        }
        this.print("\ud83d\udc4d Dependency " + parsed.getManagementKey() + " already in the pom.xml file - skipping");
        return false;
    }

    private void print(String message) {
        System.out.println(message);
    }

    private List<Dependency> getDependenciesFromBom() {
        try {
            return MojoUtils.readPom(this.getClass().getResourceAsStream("/quarkus-bom/pom.xml")).getDependencyManagement().getDependencies();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read the BOM file: " + e.getMessage(), e);
        }
    }

    private boolean containsBOM(Model model) {
        if (model.getDependencyManagement() == null) {
            return false;
        }
        List dependencies = model.getDependencyManagement().getDependencies();
        return dependencies.stream().filter(dependency -> "import".equalsIgnoreCase(dependency.getScope())).filter(dependency -> "pom".equalsIgnoreCase(dependency.getType())).anyMatch(dependency -> dependency.getArtifactId().equalsIgnoreCase(MojoUtils.getBomArtifactId()));
    }

    private boolean isDefinedInBom(List<Dependency> dependencies, Extension extension) {
        return dependencies.stream().anyMatch(dependency -> dependency.getGroupId().equalsIgnoreCase(extension.getGroupId()) && dependency.getArtifactId().equalsIgnoreCase(extension.getArtifactId()));
    }
}

