/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands.writer;

import io.quarkus.cli.commands.writer.ProjectWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipProjectWriter
implements ProjectWriter {
    private final ZipOutputStream zos;
    private final Map<String, byte[]> contentByPath = new LinkedHashMap<String, byte[]>();
    private final List<String> dirs = new ArrayList<String>();

    public ZipProjectWriter(ZipOutputStream zip) {
        this.zos = zip;
    }

    @Override
    public String mkdirs(String path) throws IOException {
        if (path.length() == 0) {
            return "";
        }
        String dirPath = path;
        if (!dirPath.endsWith("/")) {
            dirPath = dirPath + "/";
        }
        if (this.dirs.contains(dirPath)) {
            return dirPath;
        }
        ZipEntry ze = new ZipEntry(dirPath);
        this.zos.putNextEntry(ze);
        this.zos.closeEntry();
        this.dirs.add(dirPath);
        return dirPath;
    }

    @Override
    public void write(String path, String content) throws IOException {
        byte[] contentBytes = content.getBytes("UTF-8");
        this.contentByPath.put(path, contentBytes);
    }

    @Override
    public byte[] getContent(String path) {
        return this.contentByPath.get(path);
    }

    @Override
    public boolean exists(String path) {
        return this.contentByPath.containsKey(path);
    }

    @Override
    public void close() throws IOException {
        for (Map.Entry<String, byte[]> entry : this.contentByPath.entrySet()) {
            ZipEntry ze = new ZipEntry(entry.getKey());
            this.zos.putNextEntry(ze);
            this.zos.write(entry.getValue());
            this.zos.closeEntry();
        }
    }
}

