/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.templates;

import io.quarkus.templates.QuarkusTemplate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class TemplateRegistry {
    private static final Map<String, QuarkusTemplate> templates = new ConcurrentHashMap<String, QuarkusTemplate>(7);
    private static final TemplateRegistry INSTANCE = new TemplateRegistry();

    private TemplateRegistry() {
        TemplateRegistry.loadTemplates();
    }

    public static TemplateRegistry getInstance() {
        return INSTANCE;
    }

    public static QuarkusTemplate createTemplateWith(String name) throws NoSuchElementException {
        QuarkusTemplate template = templates.get(name);
        if (template == null) {
            throw new NoSuchElementException("Unknown template: " + name);
        }
        return template;
    }

    private static void register(QuarkusTemplate template) {
        if (template == null) {
            throw new NullPointerException("Cannot register null templates");
        }
        templates.put(template.getName(), template);
    }

    private static void loadTemplates() {
        ServiceLoader<QuarkusTemplate> serviceLoader = ServiceLoader.load(QuarkusTemplate.class);
        serviceLoader.iterator().forEachRemaining(TemplateRegistry::register);
    }
}

