/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.templates.rest;

import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.templates.QuarkusTemplate;
import io.quarkus.templates.SourceType;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;

public class BasicRest
implements QuarkusTemplate {
    public static final String TEMPLATE_NAME = "basic-rest";
    private Map<String, Object> context;
    private String path = "/hello";
    private ProjectWriter writer;
    private String srcMainPath;
    private String testMainPath;
    private SourceType type;

    @Override
    public String getName() {
        return TEMPLATE_NAME;
    }

    @Override
    public void generate(ProjectWriter writer, Map<String, Object> parameters) throws IOException {
        this.writer = writer;
        this.context = parameters == null ? Collections.emptyMap() : parameters;
        this.type = (SourceType)((Object)this.context.get("source_type"));
        this.initProject();
        this.setupContext();
        this.createClasses();
        this.createIndexPage();
        this.createDockerFiles();
        this.createDockerIgnore();
        this.createApplicationConfig();
        this.createGitIgnore();
    }

    private void setupContext() throws IOException {
        if (this.context.get("class_name") != null) {
            String packageName = (String)this.context.get("package_name");
            if (packageName != null) {
                String packageDir = this.srcMainPath + '/' + packageName.replace('.', '/');
                String testPackageDir = this.testMainPath + '/' + packageName.replace('.', '/');
                this.srcMainPath = this.writer.mkdirs(packageDir);
                this.testMainPath = this.writer.mkdirs(testPackageDir);
            } else {
                throw new NullPointerException("Need a non-null package name");
            }
        }
    }

    private void createClasses() throws IOException {
        Object className = this.context.get("class_name");
        if (className != null) {
            String extension = this.type.getExtension();
            String classFile = this.srcMainPath + '/' + className + extension;
            String testClassFile = this.testMainPath + '/' + className + "Test" + extension;
            String itTestClassFile = this.testMainPath + '/' + "Native" + className + "IT" + extension;
            String name = this.getName();
            this.generate(this.type.getSrcResourceTemplate(name), this.context, classFile, "resource code");
            this.generate(this.type.getTestResourceTemplate(name), this.context, testClassFile, "test code");
            this.generate(this.type.getNativeTestResourceTemplate(name), this.context, itTestClassFile, "IT code");
        }
    }

    private <T> T get(String key, String defaultValue) {
        return (T)this.context.getOrDefault(key, defaultValue);
    }

    private boolean initProject() throws IOException {
        boolean newProject;
        boolean bl = newProject = !this.writer.exists("pom.xml");
        if (newProject) {
            this.generate(this.type.getPomResourceTemplate(this.getName()), this.context, "pom.xml", "pom.xml");
        } else {
            Model model = MojoUtils.readPom(new ByteArrayInputStream(this.writer.getContent("pom.xml")));
            this.context.put("project_groupId", model.getGroupId());
            this.context.put("project_artifactId", model.getArtifactId());
        }
        this.path = (String)this.get("path", this.path);
        this.srcMainPath = this.writer.mkdirs(this.type.getSrcDir());
        this.testMainPath = this.writer.mkdirs(this.type.getTestSrcDir());
        return newProject;
    }

    private void generate(String templateName, Map<String, Object> context, String outputFilePath, String resourceType) throws IOException {
        if (!this.writer.exists(outputFilePath)) {
            String path = templateName.startsWith("/") ? templateName : "/" + templateName;
            try (BufferedReader stream = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(path), StandardCharsets.UTF_8));){
                String template = stream.lines().collect(Collectors.joining("\n"));
                for (Map.Entry<String, Object> e : context.entrySet()) {
                    if (e.getValue() == null) continue;
                    template = template.replace(String.format("${%s}", e.getKey()), e.getValue().toString());
                }
                this.writer.write(outputFilePath, template);
            }
        }
    }

    private void createIndexPage() throws IOException {
        String resources = "src/main/resources/META-INF/resources";
        String index = this.writer.mkdirs(resources) + "index.html";
        if (!this.writer.exists(index)) {
            this.generate("templates/index.ftl", this.context, index, "welcome page");
        }
    }

    private void createDockerFiles() throws IOException {
        String dockerRoot = "src/main/docker";
        String dockerRootDir = this.writer.mkdirs(dockerRoot);
        this.generate("templates/dockerfile-native.ftl", this.context, dockerRootDir + "Dockerfile.native", "native docker file");
        this.generate("templates/dockerfile-jvm.ftl", this.context, dockerRootDir + "Dockerfile.jvm", "jvm docker file");
    }

    private void createDockerIgnore() throws IOException {
        String docker = this.writer.mkdirs("") + ".dockerignore";
        this.generate("templates/dockerignore.ftl", this.context, docker, "docker ignore");
    }

    private void createGitIgnore() throws IOException {
        String gitignore = this.writer.mkdirs("") + ".gitignore";
        this.generate("templates/gitignore.ftl", this.context, gitignore, "git ignore");
    }

    private void createApplicationConfig() throws IOException {
        String meta = "src/main/resources";
        String file = this.writer.mkdirs(meta) + "application.properties";
        if (!this.writer.exists(file)) {
            this.writer.write(file, "# Configuration file" + System.lineSeparator() + "# key = value");
            System.out.println("Configuration file created in " + file);
        }
    }
}

