/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.dependencies.Extension;
import io.quarkus.generators.BuildTool;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;

public class ListExtensions {
    private static final String FULL_FORMAT = "%-8s %-50s %-50s %-25s%n%s";
    private static final String SIMPLE_FORMAT = "%-50s %-50s";
    private static final String NAME_FORMAT = "%-50s";
    private BuildFile buildFile = null;

    public ListExtensions(ProjectWriter writer, BuildTool buildTool) throws IOException {
        if (writer != null) {
            this.buildFile = buildTool.getBuildFile(writer);
        }
    }

    public void listExtensions(boolean all, String format, String search) {
        List<Extension> loadedExtensions;
        Map<String, Dependency> installed = this.findInstalled();
        Stream<Object> extensionsStream = MojoUtils.loadExtensions().stream();
        if (search != null && !"*".equalsIgnoreCase(search)) {
            Pattern searchPattern = Pattern.compile(".*" + search + ".*", 2);
            extensionsStream = extensionsStream.filter(e -> this.filterBySearch(searchPattern, (Extension)e));
        }
        if ((loadedExtensions = extensionsStream.collect(Collectors.toList())).isEmpty()) {
            System.out.println("No extension found with this pattern");
        } else {
            Consumer<String[]> currentFormatter;
            String extensionStatus = all ? "available" : "installable";
            System.out.println(String.format("%nCurrent Quarkus extensions %s: ", extensionStatus));
            switch (format.toLowerCase()) {
                case "name": {
                    currentFormatter = this::nameFormatter;
                    break;
                }
                case "full": {
                    currentFormatter = this::fullFormatter;
                    currentFormatter.accept(new String[]{"Status", "Extension", "ArtifactId", "Updated Version", "Guide"});
                    break;
                }
                default: {
                    currentFormatter = this::simpleFormatter;
                }
            }
            loadedExtensions.forEach(extension -> this.display((Extension)extension, installed, all, currentFormatter));
            if ("simple".equalsIgnoreCase(format)) {
                System.out.println("\nTo get more information, append -Dquarkus.extension.format=full to your command line.");
            }
            System.out.println("\nAdd an extension to your project by adding the dependency to your project or use `mvn quarkus:add-extension -Dextensions=\"artifactId\"`");
        }
    }

    public Map<String, Dependency> findInstalled() {
        if (this.buildFile != null) {
            return this.buildFile.findInstalled();
        }
        return Collections.emptyMap();
    }

    private boolean filterBySearch(Pattern searchPattern, Extension e) {
        return searchPattern.matcher(e.getName()).matches();
    }

    private void simpleFormatter(String[] cols) {
        System.out.println(String.format(SIMPLE_FORMAT, cols[1], cols[2], cols[4]));
    }

    private void fullFormatter(String[] cols) {
        System.out.println(String.format(FULL_FORMAT, cols[0], cols[1], cols[2], cols[3], cols[4]));
    }

    private void nameFormatter(String[] cols) {
        System.out.println(String.format(NAME_FORMAT, cols[2]));
    }

    private void display(Extension extension, Map<String, Dependency> installed, boolean all, Consumer<String[]> formatter) {
        if (!all && installed.containsKey(String.format("%s:%s", extension.getGroupId(), extension.getArtifactId()))) {
            return;
        }
        Dependency dependency = installed.get(String.format("%s:%s", extension.getGroupId(), extension.getArtifactId()));
        String label = "";
        String version = "";
        String extracted = this.extractVersion(dependency);
        if (extracted != null) {
            if (MojoUtils.getPluginVersion().equalsIgnoreCase(extracted)) {
                label = "current";
                version = String.format("%s", extracted);
            } else {
                label = "update";
                version = String.format("%s <> %s", extracted, MojoUtils.getPluginVersion());
            }
        }
        String guide = StringUtils.defaultString((String)extension.getGuide(), (String)"");
        formatter.accept(new String[]{label, extension.getName(), extension.getArtifactId(), version, guide});
    }

    private String extractVersion(Dependency dependency) {
        String value;
        String version;
        String string = version = dependency != null ? dependency.getVersion() : null;
        if (version != null && version.startsWith("$") && (value = this.buildFile.getProperty(this.propertyName(version))) != null) {
            version = value;
        }
        return version;
    }

    private String propertyName(String variable) {
        return variable.substring(2, variable.length() - 1);
    }
}

