/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.tools.config;

import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.loader.QuarkusPlatformDescriptorLoader;
import io.quarkus.platform.descriptor.loader.QuarkusPlatformDescriptorLoaderContext;
import io.quarkus.platform.tools.DefaultMessageWriter;
import io.quarkus.platform.tools.MessageWriter;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;

public class QuarkusPlatformConfig {
    private static final AtomicReference<QuarkusPlatformConfig> defaultConfig = new AtomicReference();
    private final MessageWriter log;
    private final QuarkusPlatformDescriptor platformDescr;

    public static Builder builder() {
        return new Builder(false);
    }

    public static Builder defaultConfigBuilder() {
        return new Builder(true);
    }

    public static QuarkusPlatformConfig newInstance() {
        return QuarkusPlatformConfig.builder().build();
    }

    public static QuarkusPlatformConfig getGlobalDefault() {
        QuarkusPlatformConfig c = defaultConfig.get();
        if (c != null) {
            return c;
        }
        return QuarkusPlatformConfig.defaultConfigBuilder().build();
    }

    public static boolean hasGlobalDefault() {
        return defaultConfig.get() != null;
    }

    private static void assertNoDefaultConfig() {
        if (defaultConfig.get() != null) {
            throw new IllegalStateException("The default instance of " + QuarkusPlatformConfig.class.getName() + " has already been initialized");
        }
    }

    private QuarkusPlatformConfig(Builder builder) {
        this.log = builder.getMessageWriter();
        this.platformDescr = builder.getPlatformDescriptor();
        if (builder.buildDefaultConfig) {
            QuarkusPlatformConfig.assertNoDefaultConfig();
            defaultConfig.set(this);
        }
    }

    public MessageWriter getMessageWriter() {
        return this.log;
    }

    public QuarkusPlatformDescriptor getPlatformDescriptor() {
        return this.platformDescr;
    }

    public static class Builder {
        private boolean buildDefaultConfig;
        private MessageWriter log;
        private QuarkusPlatformDescriptor platformDescr;

        private Builder(boolean buildSingleton) {
            this.buildDefaultConfig = buildSingleton;
            if (this.buildDefaultConfig) {
                QuarkusPlatformConfig.assertNoDefaultConfig();
            }
        }

        public Builder setMessageWriter(MessageWriter msgWriter) {
            this.log = msgWriter;
            return this;
        }

        private MessageWriter getMessageWriter() {
            return this.log == null ? (this.log = new DefaultMessageWriter()) : this.log;
        }

        public Builder setPlatformDescriptor(QuarkusPlatformDescriptor platformDescr) {
            this.platformDescr = platformDescr;
            return this;
        }

        private QuarkusPlatformDescriptor getPlatformDescriptor() {
            if (this.platformDescr != null) {
                return this.platformDescr;
            }
            Iterator<QuarkusPlatformDescriptorLoader> i = ServiceLoader.load(QuarkusPlatformDescriptorLoader.class).iterator();
            if (!i.hasNext()) {
                throw new IllegalStateException("Failed to locate an implementation of " + QuarkusPlatformDescriptorLoader.class.getName() + " on the classpath");
            }
            QuarkusPlatformDescriptorLoader dl = i.next();
            if (i.hasNext()) {
                StringBuilder buf = new StringBuilder();
                buf.append("Found multiple implementations of ").append(QuarkusPlatformDescriptorLoader.class.getName()).append("on the classpath: ").append(dl.getClass().getName());
                while (i.hasNext()) {
                    buf.append(", ").append(i.next().getClass().getName());
                }
                throw new IllegalStateException(buf.toString());
            }
            this.platformDescr = dl.load(new QuarkusPlatformDescriptorLoaderContext(){

                public MessageWriter getMessageWriter() {
                    return this.getMessageWriter();
                }
            });
            return this.platformDescr;
        }

        public QuarkusPlatformConfig build() {
            return new QuarkusPlatformConfig(this);
        }
    }
}

