/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.model.ImmutableRelease;
import io.quarkus.registry.model.Nullable;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableRelease.class)
@Value.Immutable
public interface Release
extends Comparable<Release> {
    public String getVersion();

    @JsonProperty(value="quarkus-core")
    @Nullable
    public String getQuarkusCore();

    @JsonProperty(value="repository-url")
    @Nullable
    @Value.Auxiliary
    public String getRepositoryURL();

    public static ImmutableRelease.Builder builder() {
        return ImmutableRelease.builder();
    }

    @Override
    default public int compareTo(Release o) {
        int compare = new ComparableVersion(this.getVersion()).compareTo(new ComparableVersion(o.getVersion()));
        if (compare == 0 && this.getQuarkusCore() != null && o.getQuarkusCore() != null) {
            compare = new ComparableVersion(this.getQuarkusCore()).compareTo(new ComparableVersion(o.getQuarkusCore()));
        }
        return compare;
    }
}

