/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.AddExtensionResult;
import io.quarkus.cli.commands.AddExtensionsCommandHandler;
import io.quarkus.cli.commands.QuarkusCommandException;
import io.quarkus.cli.commands.QuarkusCommandInvocation;
import io.quarkus.cli.commands.QuarkusCommandOutcome;
import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.file.MavenBuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.generators.BuildTool;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.platform.tools.config.QuarkusPlatformConfig;
import java.io.IOException;
import java.util.Set;

public class AddExtensions {
    public static final String NAME = "add-extensions";
    public static final String EXTENSIONS = ToolsUtils.dotJoin("quarkus", "add-extensions", "extensions");
    public static final String OUTCOME_UPDATED = ToolsUtils.dotJoin("quarkus", "add-extensions", "outcome", "updated");
    private final QuarkusCommandInvocation invocation;

    @Deprecated
    public AddExtensions(ProjectWriter writer) throws IOException {
        this(writer, QuarkusPlatformConfig.getGlobalDefault().getPlatformDescriptor());
    }

    @Deprecated
    public AddExtensions(BuildFile buildFile) throws IOException {
        this(buildFile, QuarkusPlatformConfig.getGlobalDefault().getPlatformDescriptor());
    }

    @Deprecated
    public AddExtensions(ProjectWriter writer, BuildTool buildTool) throws IOException {
        this(writer, buildTool, QuarkusPlatformConfig.getGlobalDefault().getPlatformDescriptor());
    }

    public AddExtensions(ProjectWriter writer, QuarkusPlatformDescriptor platformDescr) throws IOException {
        this(new MavenBuildFile(writer), platformDescr);
    }

    public AddExtensions(ProjectWriter writer, BuildTool buildTool, QuarkusPlatformDescriptor platformDescr) throws IOException {
        this(buildTool.createBuildFile(writer), platformDescr);
    }

    public AddExtensions(BuildFile buildFile, QuarkusPlatformDescriptor platformDescr) {
        this.invocation = new QuarkusCommandInvocation(platformDescr);
        this.invocation.setBuildFile(buildFile);
    }

    public AddExtensions extensions(Set<String> extensions) {
        this.invocation.setValue(EXTENSIONS, extensions);
        return this;
    }

    @Deprecated
    public AddExtensionResult addExtensions(Set<String> extensions) throws IOException {
        QuarkusCommandOutcome outcome;
        try {
            outcome = this.extensions(extensions).execute();
        }
        catch (QuarkusCommandException e) {
            throw new IOException("Failed to list extensions", e);
        }
        return new AddExtensionResult(outcome.getValue(OUTCOME_UPDATED, false), outcome.isSuccess());
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        return new AddExtensionsCommandHandler().execute(this.invocation);
    }
}

