/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.buildfile.BuildFile;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public abstract class AbstractGradleBuildFile
extends BuildFile {
    private static final String BUILD_GRADLE_PATH = "build.gradle";
    private static final String SETTINGS_GRADLE_PATH = "settings.gradle";
    private static final String GRADLE_PROPERTIES_PATH = "gradle.properties";
    private final Optional<Path> rootProjectPath;
    private AtomicReference<Model> modelReference = new AtomicReference();

    public AbstractGradleBuildFile(Path projectDirPath, QuarkusPlatformDescriptor platformDescriptor) {
        super(projectDirPath, platformDescriptor);
        this.rootProjectPath = Optional.empty();
    }

    public AbstractGradleBuildFile(Path projectDirPath, QuarkusPlatformDescriptor platformDescriptor, Path rootProjectPath) {
        super(projectDirPath, platformDescriptor);
        this.rootProjectPath = Optional.ofNullable(rootProjectPath);
    }

    @Override
    public void writeToDisk() throws IOException {
        if (this.rootProjectPath.isPresent()) {
            Files.write(this.rootProjectPath.get().resolve(SETTINGS_GRADLE_PATH), this.getModel().getRootSettingsContent().getBytes(), new OpenOption[0]);
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                this.getModel().getRootPropertiesContent().store(out, "Gradle properties");
                Files.write(this.rootProjectPath.get().resolve(GRADLE_PROPERTIES_PATH), this.getModel().getRootSettingsContent().getBytes(), new OpenOption[0]);
            }
        }
        this.writeToProjectFile(SETTINGS_GRADLE_PATH, this.getModel().getSettingsContent().getBytes());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.getModel().getPropertiesContent().store(out, "Gradle properties");
            this.writeToProjectFile(GRADLE_PROPERTIES_PATH, out.toByteArray());
        }
        this.writeToProjectFile(BUILD_GRADLE_PATH, this.getModel().getBuildContent().getBytes());
    }

    @Override
    protected void addDependencyInBuildFile(AppArtifactCoords coords) throws IOException {
        AbstractGradleBuildFile.addDependencyInModel(this.getModel(), coords);
    }

    static void addDependencyInModel(Model model, AppArtifactCoords coords) throws IOException {
        StringBuilder newBuildContent = new StringBuilder();
        AbstractGradleBuildFile.readLineByLine(model.getBuildContent(), currentLine -> {
            newBuildContent.append((String)currentLine).append(System.lineSeparator());
            if (currentLine.startsWith("dependencies {")) {
                newBuildContent.append("    implementation '").append(coords.getGroupId()).append(":").append(coords.getArtifactId());
                if (coords.getVersion() != null && !coords.getVersion().isEmpty()) {
                    newBuildContent.append(":").append(coords.getVersion());
                }
                newBuildContent.append("'").append(System.lineSeparator());
            }
        });
        model.setBuildContent(newBuildContent.toString());
    }

    @Override
    protected void removeDependencyFromBuildFile(AppArtifactKey key) throws IOException {
        StringBuilder newBuildContent = new StringBuilder();
        Scanner scanner = new Scanner(this.getModel().getBuildContent());
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.contains(key.getGroupId() + ":" + key.getArtifactId())) continue;
            newBuildContent.append(line).append(System.lineSeparator());
        }
        scanner.close();
        this.getModel().setBuildContent(newBuildContent.toString());
    }

    @Override
    protected boolean containsBOM(String groupId, String artifactId) throws IOException {
        String buildContent = this.getModel().getBuildContent();
        return buildContent.contains("enforcedPlatform(\"${quarkusPlatformGroupId}:${quarkusPlatformArtifactId}:") || buildContent.contains("enforcedPlatform(\"" + groupId + ":" + artifactId + ":");
    }

    @Override
    public String getProperty(String propertyName) throws IOException {
        String property = this.getModel().getPropertiesContent().getProperty(propertyName);
        if (property != null || this.getModel().getRootPropertiesContent() == null) {
            return property;
        }
        return this.getModel().getRootPropertiesContent().getProperty(propertyName);
    }

    @Override
    public BuildTool getBuildTool() {
        return BuildTool.GRADLE;
    }

    private Model getModel() throws IOException {
        return this.modelReference.updateAndGet(model -> {
            if (model == null) {
                try {
                    return this.readModel();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return model;
        });
    }

    @Override
    protected void refreshData() {
        this.modelReference.set(null);
    }

    private boolean hasRootProjectFile(String fileName) throws IOException {
        if (!this.rootProjectPath.isPresent()) {
            return false;
        }
        Path filePath = this.rootProjectPath.get().resolve(fileName);
        return Files.exists(filePath, new LinkOption[0]);
    }

    private byte[] readRootProjectFile(String fileName) throws IOException {
        Path filePath = this.rootProjectPath.orElseThrow(() -> new IllegalStateException("There is no rootProject defined in this GradleBuildFile")).resolve(fileName);
        return Files.readAllBytes(filePath);
    }

    private Model readModel() throws IOException {
        byte[] properties;
        byte[] settings;
        String settingsContent = "";
        String buildContent = "";
        Properties propertiesContent = new Properties();
        String rootSettingsContent = null;
        Properties rootPropertiesContent = null;
        if (this.hasProjectFile(SETTINGS_GRADLE_PATH)) {
            settings = this.readProjectFile(SETTINGS_GRADLE_PATH);
            settingsContent = new String(settings, StandardCharsets.UTF_8);
        }
        if (this.hasRootProjectFile(SETTINGS_GRADLE_PATH)) {
            settings = this.readRootProjectFile(SETTINGS_GRADLE_PATH);
            rootSettingsContent = new String(settings, StandardCharsets.UTF_8);
        }
        if (this.hasProjectFile(BUILD_GRADLE_PATH)) {
            byte[] build = this.readProjectFile(BUILD_GRADLE_PATH);
            buildContent = new String(build, StandardCharsets.UTF_8);
        }
        if (this.hasProjectFile(GRADLE_PROPERTIES_PATH)) {
            properties = this.readProjectFile(GRADLE_PROPERTIES_PATH);
            propertiesContent.load(new ByteArrayInputStream(properties));
        }
        if (this.hasRootProjectFile(GRADLE_PROPERTIES_PATH)) {
            properties = this.readRootProjectFile(GRADLE_PROPERTIES_PATH);
            rootPropertiesContent = new Properties();
            rootPropertiesContent.load(new ByteArrayInputStream(properties));
        }
        return new Model(settingsContent, buildContent, propertiesContent, rootSettingsContent, rootPropertiesContent);
    }

    protected String getBuildContent() throws IOException {
        return this.getModel().getBuildContent();
    }

    private static void readLineByLine(String content, Consumer<String> lineConsumer) {
        try (Scanner scanner = new Scanner((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8.name());){
            while (scanner.hasNextLine()) {
                String currentLine = scanner.nextLine();
                lineConsumer.accept(currentLine);
            }
        }
    }

    static class Model {
        private String settingsContent;
        private String buildContent;
        private Properties propertiesContent;
        private String rootSettingsContent;
        private Properties rootPropertiesContent;

        public Model(String settingsContent, String buildContent, Properties propertiesContent, String rootSettingsContent, Properties rootPropertiesContent) {
            this.settingsContent = settingsContent;
            this.buildContent = buildContent;
            this.propertiesContent = propertiesContent;
            this.rootSettingsContent = rootSettingsContent;
            this.rootPropertiesContent = rootPropertiesContent;
        }

        public String getSettingsContent() {
            return this.settingsContent;
        }

        public String getBuildContent() {
            return this.buildContent;
        }

        public Properties getPropertiesContent() {
            return this.propertiesContent;
        }

        public String getRootSettingsContent() {
            return this.rootSettingsContent;
        }

        public Properties getRootPropertiesContent() {
            return this.rootPropertiesContent;
        }

        public void setSettingsContent(String settingsContent) {
            this.settingsContent = settingsContent;
        }

        public void setBuildContent(String buildContent) {
            this.buildContent = buildContent;
        }
    }
}

