/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.dependencies.Extension;
import io.quarkus.devtools.codestarts.CodestartInput;
import io.quarkus.devtools.codestarts.CodestartInputBuilder;
import io.quarkus.devtools.codestarts.CodestartResourceLoader;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public final class QuarkusCodestarts {
    private QuarkusCodestarts() {
    }

    public static CodestartInputBuilder inputBuilder(QuarkusPlatformDescriptor platformDescr) {
        return CodestartInput.builder((CodestartResourceLoader)QuarkusCodestarts.resourceLoader(platformDescr), QuarkusCodestarts.buildCodestartMapping(platformDescr.getExtensions()));
    }

    public static CodestartResourceLoader resourceLoader(QuarkusPlatformDescriptor platformDescr) {
        return new QuarkusPlatformCodestartResourceLoader(platformDescr);
    }

    public static Map<AppArtifactKey, String> buildCodestartMapping(Collection<Extension> extensions) {
        return extensions.stream().filter(e -> e.getCodestart() != null).collect(Collectors.toMap(e -> new AppArtifactKey(e.getGroupId(), e.getArtifactId(), e.getClassifier(), e.getType() == null ? "jar" : e.getType()), Extension::getCodestart));
    }

    private static class QuarkusPlatformCodestartResourceLoader
    implements CodestartResourceLoader {
        private QuarkusPlatformDescriptor platformDescr;

        QuarkusPlatformCodestartResourceLoader(QuarkusPlatformDescriptor platformDescr) {
            this.platformDescr = platformDescr;
        }

        public <T> T loadResourceAsPath(String name, CodestartResourceLoader.Consumer<T> consumer) throws IOException {
            return (T)this.platformDescr.loadResourceAsPath(name, arg_0 -> consumer.consume(arg_0));
        }
    }
}

