/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartData;
import io.quarkus.devtools.codestarts.CodestartInput;
import io.quarkus.devtools.codestarts.CodestartProject;
import io.quarkus.devtools.codestarts.CodestartSpec;
import io.quarkus.devtools.codestarts.Codestarts;
import io.quarkus.devtools.codestarts.NestedMaps;
import io.quarkus.devtools.codestarts.QuarkusCodestarts;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.buildfile.GradleBuildFilesCreator;
import io.quarkus.devtools.project.codegen.ProjectGeneratorRegistry;
import io.quarkus.devtools.project.codegen.SourceType;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.ConsoleMessageFormats;
import io.quarkus.platform.tools.ToolsUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class CreateProjectCommandHandler
implements QuarkusCommandHandler {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        QuarkusPlatformDescriptor platformDescr = invocation.getPlatformDescriptor();
        invocation.setValue("bom_groupId", platformDescr.getBomGroupId());
        invocation.setValue("bom_artifactId", platformDescr.getBomArtifactId());
        invocation.setValue("quarkus_version", platformDescr.getQuarkusVersion());
        invocation.setValue("bom_version", platformDescr.getBomVersion());
        Set<String> extensionsQuery = invocation.getValue("extensions", Collections.emptySet());
        Properties quarkusProps = ToolsUtils.readQuarkusProperties(platformDescr);
        quarkusProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String name = k.toString().replace("-", "_");
            if (!invocation.hasValue(name)) {
                invocation.setValue(k.toString().replace("-", "_"), v.toString());
            }
        }));
        if (invocation.getValue("codestarts.enabled", false)) {
            List extensionsToAdd = QuarkusCommandHandlers.computeCoordsFromQuery(invocation, extensionsQuery).stream().map(AppArtifactCoords::getKey).collect(Collectors.toList());
            try {
                CodestartInput input = QuarkusCodestarts.inputBuilder(platformDescr).addExtensions(extensionsToAdd).addData(CodestartData.LegacySupport.convertFromLegacy(invocation.getValues())).putData(CodestartData.DataKey.BUILDTOOL.getKey(), (Object)invocation.getQuarkusProject().getBuildTool().toString().toLowerCase()).includeExamples(invocation.getValue("codestarts.with-example-code", true)).build();
                invocation.log().info("Generating Quarkus Codestart Project with data: " + input.getData().toString());
                CodestartProject codestartProject = Codestarts.prepareProject((CodestartInput)input);
                invocation.log().info("Codestarts: " + codestartProject.getCodestarts().stream().map(Codestart::getSpec).map(CodestartSpec::getName).collect(Collectors.joining(", ")));
                Codestarts.generateProject((CodestartProject)codestartProject, (Path)invocation.getQuarkusProject().getProjectDirPath());
            }
            catch (IOException e) {
                throw new QuarkusCommandException("Failed to create project", e);
            }
            return QuarkusCommandOutcome.success();
        }
        CreateProjectCommandHandler.addPlatformDataToLegacyCodegen(invocation);
        try {
            List<AppArtifactCoords> extensionsToAdd;
            String className = invocation.getStringValue("class_name");
            if (className != null) {
                className = invocation.getValue("source_type", SourceType.JAVA).stripExtensionFrom(className);
                int idx = className.lastIndexOf(46);
                if (idx >= 0) {
                    String pkgName = invocation.getStringValue("package_name");
                    if (pkgName == null) {
                        invocation.setValue("package_name", className.substring(0, idx));
                    }
                    className = className.substring(idx + 1);
                }
                invocation.setValue("class_name", className);
            }
            if ((extensionsToAdd = QuarkusCommandHandlers.computeCoordsFromQuery(invocation, extensionsQuery)) != null) {
                ProjectGeneratorRegistry.get("basic-rest").generate(invocation);
                if (invocation.getQuarkusProject().getBuildTool().equals((Object)BuildTool.GRADLE)) {
                    GradleBuildFilesCreator generator = new GradleBuildFilesCreator(invocation.getQuarkusProject());
                    generator.create(invocation.getStringValue("project_groupId"), invocation.getStringValue("project_artifactId"), invocation.getStringValue("project_version"), quarkusProps, extensionsToAdd);
                } else {
                    ExtensionManager.InstallResult result = invocation.getQuarkusProject().getExtensionManager().install(extensionsToAdd);
                    result.getInstalled().forEach(a -> invocation.log().info(ConsoleMessageFormats.ok((String)("Extension " + a.getGroupId() + ":" + a.getArtifactId())) + " has been installed"));
                }
            }
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Failed to create project", e);
        }
        return QuarkusCommandOutcome.success();
    }

    static void addPlatformDataToLegacyCodegen(QuarkusCommandInvocation invocation) {
        BuildTool buildTool = invocation.getQuarkusProject().getBuildTool();
        if (BuildTool.MAVEN == buildTool) {
            Map repo;
            Optional mavenPluginRepositories;
            Map repo2;
            Optional mavenRepositories = NestedMaps.getValue((Map)invocation.getPlatformDescriptor().getMetadata(), (String)"maven.repositories");
            if (mavenRepositories.isPresent() && !((List)mavenRepositories.get()).isEmpty() && (repo2 = (Map)((List)mavenRepositories.get()).get(0)) != null && repo2.get("id") instanceof String && repo2.get("url") instanceof String) {
                StringBuilder repositories = new StringBuilder().append("\n").append("    <repositories>\n").append("        <repository>\n").append("            <id>").append(repo2.get("id")).append("</id>\n").append("            <url>").append(repo2.get("url")).append("</url>\n").append("            <releases>\n").append("                <enabled>").append(repo2.getOrDefault("releases-enabled", true)).append("</enabled>\n").append("            </releases>\n").append("            <snapshots>\n").append("                <enabled>").append(repo2.getOrDefault("snapshots-enabled", true)).append("</enabled>\n").append("            </snapshots>\n").append("        </repository>\n").append("    </repositories>\n");
                invocation.setValue("maven_repositories", repositories.toString());
            }
            if ((mavenPluginRepositories = NestedMaps.getValue((Map)invocation.getPlatformDescriptor().getMetadata(), (String)"maven.plugin-repositories")).isPresent() && !((List)mavenPluginRepositories.get()).isEmpty() && (repo = (Map)((List)mavenPluginRepositories.get()).get(0)) != null && repo.get("id") instanceof String && repo.get("url") instanceof String) {
                StringBuilder pluginRepositories = new StringBuilder().append("\n").append("    <pluginRepositories>\n").append("        <pluginRepository>\n").append("            <id>").append(repo.get("id")).append("</id>\n").append("            <url>").append(repo.get("url")).append("</url>\n").append("            <releases>\n").append("                <enabled>").append(repo.getOrDefault("releases-enabled", true)).append("</enabled>\n").append("            </releases>\n").append("            <snapshots>\n").append("                <enabled>").append(repo.getOrDefault("snapshots-enabled", true)).append("</enabled>\n").append("            </snapshots>\n").append("        </pluginRepository>\n").append("    </pluginRepositories>\n");
                invocation.setValue("maven_plugin_repositories", pluginRepositories.toString());
            }
        } else if (BuildTool.GRADLE == buildTool) {
            Map repo;
            Optional gradlePluginRepositories;
            Map repo3;
            Optional gradleRepositories = NestedMaps.getValue((Map)invocation.getPlatformDescriptor().getMetadata(), (String)"gradle.repositories");
            if (gradleRepositories.isPresent() && !((List)gradleRepositories.get()).isEmpty() && (repo3 = (Map)((List)gradleRepositories.get()).get(0)) != null && repo3.get("url") instanceof String) {
                String repositories = "\n     maven { url \"" + repo3.get("url") + "\" }";
                invocation.setValue("maven_repositories", repositories);
            }
            if ((gradlePluginRepositories = NestedMaps.getValue((Map)invocation.getPlatformDescriptor().getMetadata(), (String)"gradle.plugin-repositories")).isPresent() && !((List)gradlePluginRepositories.get()).isEmpty() && (repo = (Map)((List)gradlePluginRepositories.get()).get(0)) != null && repo.get("url") instanceof String) {
                String pluginRepositories = "\n     maven { url \"" + repo.get("url") + "\" }";
                invocation.setValue("maven_plugin_repositories", pluginRepositories);
            }
        }
    }
}

