/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project;

import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.buildfile.GenericGradleBuildFile;
import io.quarkus.devtools.project.buildfile.MavenBuildFile;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.nio.file.Path;

public enum BuildTool {
    MAVEN("\n# Maven\ntarget/\npom.xml.tag\npom.xml.releaseBackup\npom.xml.versionsBackup\nrelease.properties", "target", new String[]{"pom.xml"}),
    GRADLE("\n# Gradle\n.gradle/\nbuild/", "build", new String[]{"build.gradle", "settings.gradle", "gradle.properties"});

    private final String gitIgnoreEntries;
    private final String buildDirectory;
    private final String[] buildFiles;

    private BuildTool(String gitIgnoreEntries, String buildDirectory, String[] buildFiles) {
        this.gitIgnoreEntries = gitIgnoreEntries;
        this.buildDirectory = buildDirectory;
        this.buildFiles = buildFiles;
    }

    public String getGitIgnoreEntries() {
        return this.gitIgnoreEntries;
    }

    public String[] getBuildFiles() {
        return this.buildFiles;
    }

    public String getDependenciesFile() {
        return this.buildFiles[0];
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    public ExtensionManager createExtensionManager(Path projectDirPath, QuarkusPlatformDescriptor platformDescriptor) {
        switch (this) {
            case GRADLE: {
                return new GenericGradleBuildFile();
            }
        }
        return new MavenBuildFile(projectDirPath, platformDescriptor);
    }

    public static BuildTool resolveExistingProject(Path path) {
        return QuarkusProject.resolveExistingProjectBuildTool(path);
    }

    public static BuildTool findTool(String tool) {
        if ("GRADLE".equalsIgnoreCase(tool)) {
            return GRADLE;
        }
        if ("MAVEN".equalsIgnoreCase(tool)) {
            return MAVEN;
        }
        return null;
    }
}

