/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.buildfile.AbstractGradleBuildFile;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.ToolsUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;

public final class GradleBuildFilesCreator {
    private static final String BUILD_GRADLE_PATH = "build.gradle";
    private static final String SETTINGS_GRADLE_PATH = "settings.gradle";
    private static final String GRADLE_PROPERTIES_PATH = "gradle.properties";
    private final QuarkusProject quarkusProject;
    private AtomicReference<AbstractGradleBuildFile.Model> modelReference = new AtomicReference();

    public GradleBuildFilesCreator(QuarkusProject quarkusProject) {
        this.quarkusProject = quarkusProject;
    }

    public void create(String groupId, String artifactId, String version, Properties properties, List<AppArtifactCoords> extensions) throws IOException {
        this.createSettingsContent(artifactId);
        this.createBuildContent(groupId, version);
        this.createProperties();
        extensions.forEach(e -> {
            try {
                this.addDependencyInBuildFile((AppArtifactCoords)e);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
        this.writeToDisk();
    }

    private void writeToDisk() throws IOException {
        this.writeToProjectFile(SETTINGS_GRADLE_PATH, this.getModel().getSettingsContent().getBytes());
        this.writeToProjectFile(BUILD_GRADLE_PATH, this.getModel().getBuildContent().getBytes());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.getModel().getPropertiesContent().store(out, "Gradle properties");
            this.writeToProjectFile(GRADLE_PROPERTIES_PATH, out.toByteArray());
        }
    }

    private void addDependencyInBuildFile(AppArtifactCoords coords) throws IOException {
        AbstractGradleBuildFile.addDependencyInModel(this.getModel(), coords, false);
    }

    protected boolean containsBOM(String groupId, String artifactId) throws IOException {
        String buildContent = this.getModel().getBuildContent();
        return buildContent.contains("enforcedPlatform(\"${quarkusPlatformGroupId}:${quarkusPlatformArtifactId}:") || buildContent.contains("enforcedPlatform(\"" + groupId + ":" + artifactId + ":");
    }

    public String getProperty(String propertyName) throws IOException {
        return this.getModel().getPropertiesContent().getProperty(propertyName);
    }

    private AbstractGradleBuildFile.Model getModel() throws IOException {
        return this.modelReference.updateAndGet(model -> {
            if (model == null) {
                try {
                    return this.readModel();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return model;
        });
    }

    private AbstractGradleBuildFile.Model readModel() throws IOException {
        String settingsContent = "";
        String buildContent = "";
        Properties propertiesContent = new Properties();
        if (this.hasProjectFile(SETTINGS_GRADLE_PATH)) {
            byte[] settings = this.readProjectFile(SETTINGS_GRADLE_PATH);
            settingsContent = new String(settings, StandardCharsets.UTF_8);
        }
        if (this.hasProjectFile(BUILD_GRADLE_PATH)) {
            byte[] build = this.readProjectFile(BUILD_GRADLE_PATH);
            buildContent = new String(build, StandardCharsets.UTF_8);
        }
        if (this.hasProjectFile(GRADLE_PROPERTIES_PATH)) {
            byte[] properties = this.readProjectFile(GRADLE_PROPERTIES_PATH);
            propertiesContent.load(new ByteArrayInputStream(properties));
        }
        return new AbstractGradleBuildFile.Model(settingsContent, buildContent, propertiesContent, null, null);
    }

    protected boolean hasProjectFile(String fileName) throws IOException {
        Path filePath = this.quarkusProject.getProjectDirPath().resolve(fileName);
        return Files.exists(filePath, new LinkOption[0]);
    }

    protected byte[] readProjectFile(String fileName) throws IOException {
        Path filePath = this.quarkusProject.getProjectDirPath().resolve(fileName);
        return Files.readAllBytes(filePath);
    }

    protected void writeToProjectFile(String fileName, byte[] content) throws IOException {
        Files.write(this.quarkusProject.getProjectDirPath().resolve(fileName), content, new OpenOption[0]);
    }

    private void createBuildContent(String groupId, String version) throws IOException {
        String versionLine;
        String groupLine;
        String buildContent = this.getModel().getBuildContent();
        StringBuilder res = new StringBuilder(buildContent);
        if (!buildContent.contains("id 'io.quarkus'")) {
            res.append("plugins {");
            res.append(System.lineSeparator()).append("    id 'java'").append(System.lineSeparator());
            res.append(System.lineSeparator()).append("    id 'io.quarkus'").append(System.lineSeparator());
            res.append("}");
        }
        if (!this.containsBOM(this.quarkusProject.getPlatformDescriptor().getBomGroupId(), this.quarkusProject.getPlatformDescriptor().getBomArtifactId())) {
            res.append(System.lineSeparator());
            res.append("dependencies {").append(System.lineSeparator());
            res.append("    implementation enforcedPlatform(\"${quarkusPlatformGroupId}:${quarkusPlatformArtifactId}:${quarkusPlatformVersion}\")").append(System.lineSeparator());
            res.append("    implementation 'io.quarkus:quarkus-resteasy'").append(System.lineSeparator());
            res.append("    testImplementation 'io.quarkus:quarkus-junit5'").append(System.lineSeparator());
            res.append("    testImplementation 'io.rest-assured:rest-assured'").append(System.lineSeparator());
            res.append("}").append(System.lineSeparator());
        }
        if (!buildContent.contains(groupLine = "group '" + groupId + "'")) {
            res.append(System.lineSeparator()).append(groupLine).append(System.lineSeparator());
        }
        if (!buildContent.contains(versionLine = "version '" + version + "'")) {
            res.append(System.lineSeparator()).append(versionLine).append(System.lineSeparator());
        }
        res.append(System.lineSeparator()).append("test {").append(System.lineSeparator()).append("    systemProperty \"java.util.logging.manager\", \"org.jboss.logmanager.LogManager\"").append(System.lineSeparator()).append("}");
        this.getModel().setBuildContent(res.toString());
    }

    private void createSettingsContent(String artifactId) throws IOException {
        String settingsContent = this.getModel().getSettingsContent();
        StringBuilder res = new StringBuilder();
        if (!settingsContent.contains("id 'io.quarkus'")) {
            res.append(System.lineSeparator());
            res.append("pluginManagement {").append(System.lineSeparator());
            res.append("    repositories {").append(System.lineSeparator());
            res.append("        mavenLocal()").append(System.lineSeparator());
            res.append("        mavenCentral()").append(System.lineSeparator());
            res.append("        gradlePluginPortal()").append(System.lineSeparator());
            res.append("    }").append(System.lineSeparator());
            res.append("    plugins {").append(System.lineSeparator());
            res.append("        id 'io.quarkus' version \"${quarkusPluginVersion}\"").append(System.lineSeparator());
            res.append("    }").append(System.lineSeparator());
            res.append("}").append(System.lineSeparator());
        }
        if (!settingsContent.contains("rootProject.name")) {
            res.append(System.lineSeparator()).append("rootProject.name='").append(artifactId).append("'").append(System.lineSeparator());
        }
        res.append(settingsContent);
        this.getModel().setSettingsContent(res.toString());
    }

    private void createProperties() throws IOException {
        QuarkusPlatformDescriptor platform = this.quarkusProject.getPlatformDescriptor();
        Properties props = this.getModel().getPropertiesContent();
        if (props.getProperty("quarkusPluginVersion") == null) {
            props.setProperty("quarkusPluginVersion", ToolsUtils.getPluginVersion(ToolsUtils.readQuarkusProperties(platform)));
        }
        if (props.getProperty("quarkusPlatformGroupId") == null) {
            props.setProperty("quarkusPlatformGroupId", platform.getBomGroupId());
        }
        if (props.getProperty("quarkusPlatformArtifactId") == null) {
            props.setProperty("quarkusPlatformArtifactId", platform.getBomArtifactId());
        }
        if (props.getProperty("quarkusPlatformVersion") == null) {
            props.setProperty("quarkusPlatformVersion", platform.getBomVersion());
        }
    }
}

