/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartData;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.CreateProjectCommandHandler;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.codegen.SourceType;
import io.quarkus.platform.tools.ToolsUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.apache.commons.lang3.StringUtils;

public class CreateProject {
    public static final String NAME = "create-project";
    public static final String NO_DOCKERFILES = ToolsUtils.dotJoin("quarkus", "create-project", "no-dockerfiles");
    public static final String NO_BUILDTOOL_WRAPPER = ToolsUtils.dotJoin("quarkus", "create-project", "no-buildtool-wrapper");
    public static final String NO_CODE = ToolsUtils.dotJoin("quarkus", "create-project", "no-code");
    public static final String EXAMPLE = ToolsUtils.dotJoin("quarkus", "create-project", "example");
    public static final String EXTRA_CODESTARTS = ToolsUtils.dotJoin("quarkus", "create-project", "extra-codestarts");
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("(?:1\\.)?(\\d+)(?:\\..*)?");
    private QuarkusProject quarkusProject;
    private String javaTarget;
    private Set<String> extensions = new HashSet<String>();
    private Map<String, Object> values = new HashMap<String, Object>();

    public CreateProject(QuarkusProject project) {
        this.quarkusProject = Objects.requireNonNull(project, "project is required");
    }

    public CreateProject groupId(String groupId) {
        this.setValue("project_groupId", groupId);
        return this;
    }

    public CreateProject artifactId(String artifactId) {
        this.setValue("project_artifactId", artifactId);
        return this;
    }

    public CreateProject version(String version) {
        this.setValue("project_version", version);
        return this;
    }

    @Deprecated
    public CreateProject quarkusMavenPluginVersion(String version) {
        this.setValue("maven_plugin_version", version);
        return this;
    }

    @Deprecated
    public CreateProject quarkusGradlePluginVersion(String version) {
        this.setValue("gradle_plugin_version", version);
        return this;
    }

    public CreateProject quarkusPluginVersion(String version) {
        if (this.quarkusProject.getBuildTool().equals((Object)BuildTool.MAVEN)) {
            this.setValue("maven_plugin_version", version);
        } else {
            this.setValue("gradle_plugin_version", version);
        }
        return this;
    }

    public CreateProject sourceType(SourceType sourceType) {
        this.setValue("source_type", (Object)sourceType);
        return this;
    }

    public CreateProject extraCodestarts(Set<String> extraCodestarts) {
        this.setValue(EXTRA_CODESTARTS, extraCodestarts);
        return this;
    }

    public CreateProject javaTarget(String javaTarget) {
        this.javaTarget = javaTarget;
        return this;
    }

    public CreateProject resourcePath(String resourcePath) {
        this.setValue("path", resourcePath);
        return this;
    }

    public CreateProject appConfig(String appConfigAsString) {
        Map<Object, Object> configMap = Collections.emptyMap();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appConfigAsString})) {
            configMap = ToolsUtils.stringToMap(appConfigAsString, ",", "=");
        }
        this.setValue(QuarkusCodestartData.QuarkusDataKey.APP_CONFIG.key(), configMap);
        return this;
    }

    @Deprecated
    public CreateProject className(String className) {
        if (className == null) {
            return this;
        }
        if (!SourceVersion.isName(className) || SourceVersion.isKeyword(className)) {
            throw new IllegalArgumentException(className + " is not a valid class name");
        }
        this.setValue("class_name", className);
        return this;
    }

    public CreateProject packageName(String packageName) {
        if (packageName == null) {
            return this;
        }
        if (!SourceVersion.isName(packageName) || SourceVersion.isKeyword(packageName)) {
            throw new IllegalArgumentException(packageName + " is not a  package name");
        }
        this.setValue("package_name", packageName);
        return this;
    }

    public CreateProject extensions(Set<String> extensions) {
        if (extensions == null) {
            return this;
        }
        this.extensions.addAll(extensions);
        return this;
    }

    public CreateProject example(String example) {
        this.setValue(EXAMPLE, example);
        return this;
    }

    public CreateProject noCode(boolean value) {
        this.setValue(NO_CODE, value);
        return this;
    }

    public CreateProject noCode() {
        return this.noCode(true);
    }

    public CreateProject noBuildToolWrapper(boolean value) {
        this.setValue(NO_BUILDTOOL_WRAPPER, value);
        return this;
    }

    public CreateProject noBuildToolWrapper() {
        return this.noBuildToolWrapper(true);
    }

    public CreateProject noDockerfiles(boolean value) {
        this.setValue(NO_DOCKERFILES, value);
        return this;
    }

    public CreateProject noDockerfiles() {
        return this.noDockerfiles(true);
    }

    public CreateProject setValue(String name, Object value) {
        if (value != null) {
            this.values.put(name, value);
        }
        return this;
    }

    public boolean doCreateProject(Map<String, Object> context) throws QuarkusCommandException {
        if (context != null && !context.isEmpty()) {
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                if (entry.getValue() == null) continue;
                this.setValue(entry.getKey(), entry.getValue());
            }
        }
        return this.execute().isSuccess();
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        Matcher matcher = JAVA_VERSION_PATTERN.matcher(this.javaTarget != null ? this.javaTarget : System.getProperty("java.version", ""));
        if (matcher.matches() && Integer.parseInt(matcher.group(1)) < 11) {
            this.setValue("java_target", "8");
        } else {
            this.setValue("java_target", "11");
        }
        if (CreateProject.containsSpringWeb(this.extensions)) {
            this.setValue("is_spring", true);
            if (CreateProject.containsRESTEasy(this.extensions)) {
                this.values.remove("class_name");
                this.values.remove("path");
            }
        }
        this.setValue("extensions", this.extensions);
        QuarkusCommandInvocation invocation = new QuarkusCommandInvocation(this.quarkusProject, this.values);
        return new CreateProjectCommandHandler().execute(invocation);
    }

    public static SourceType determineSourceType(Set<String> extensions) {
        Optional<SourceType> sourceType = extensions.stream().map(SourceType::parse).filter(Optional::isPresent).map(e -> e.orElse(SourceType.JAVA)).findAny();
        return sourceType.orElse(SourceType.JAVA);
    }

    private static boolean containsSpringWeb(Collection<String> extensions) {
        return extensions.stream().anyMatch(e -> e.toLowerCase().contains("spring-web"));
    }

    private static boolean containsRESTEasy(Collection<String> extensions) {
        return extensions.isEmpty() || extensions.stream().anyMatch(e -> e.toLowerCase().contains("resteasy"));
    }
}

