/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.codestarts.CodestartProjectDefinition;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartCatalog;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartData;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartProjectInput;
import io.quarkus.devtools.commands.CreateProject;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.union.ElementCatalog;
import io.quarkus.registry.union.ElementCatalogBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class CreateProjectCommandHandler
implements QuarkusCommandHandler {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        List<ArtifactCoords> extensionsToAdd;
        ExtensionCatalog extensionCatalog = invocation.getExtensionsCatalog();
        Set<String> extensionsQuery = invocation.getValue("extensions", Collections.emptySet());
        Properties quarkusProps = ToolsUtils.readQuarkusProperties(extensionCatalog);
        quarkusProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String name = k.toString().replace("-", "_");
            if (!invocation.hasValue(name)) {
                invocation.setValue(k.toString().replace("-", "_"), v.toString());
            }
        }));
        String className = invocation.getStringValue("class_name");
        String pkgName = invocation.getStringValue("package_name");
        String groupId = invocation.getStringValue("project_groupId");
        if (pkgName == null) {
            if (className != null && className.contains(".")) {
                int idx = className.lastIndexOf(46);
                invocation.setValue("package_name", className.substring(0, idx));
                invocation.setValue("class_name", className.substring(idx + 1));
            } else if (groupId != null) {
                invocation.setValue("package_name", groupId.replace("-", ".").replace("_", "."));
            }
        }
        if ((extensionsToAdd = QuarkusCommandHandlers.computeCoordsFromQuery(invocation, extensionsQuery)) == null) {
            throw new QuarkusCommandException("Failed to create project because of invalid extensions");
        }
        ArtifactCoords bom = null;
        List<ArtifactCoords> boms = this.getExtensionBoms(extensionCatalog, extensionsToAdd);
        if (boms.isEmpty()) {
            bom = extensionCatalog.getBom();
        } else {
            Iterator<ArtifactCoords> i = boms.iterator();
            while (i.hasNext()) {
                ArtifactCoords next = i.next();
                if (!next.getArtifactId().equals("quarkus-bom")) continue;
                bom = next;
                i.remove();
                break;
            }
        }
        if (bom == null) {
            throw new QuarkusCommandException("The platform BOM is missing");
        }
        invocation.setValue("bom_groupId", bom.getGroupId());
        invocation.setValue("bom_artifactId", bom.getArtifactId());
        invocation.setValue("bom_version", bom.getVersion());
        invocation.setValue("quarkus_version", extensionCatalog.getQuarkusCoreVersion());
        try {
            HashMap platformData = new HashMap();
            if (extensionCatalog.getMetadata().get("maven") != null) {
                platformData.put("maven", extensionCatalog.getMetadata().get("maven"));
            }
            if (extensionCatalog.getMetadata().get("gradle") != null) {
                platformData.put("gradle", extensionCatalog.getMetadata().get("gradle"));
            }
            QuarkusCodestartProjectInput input = QuarkusCodestartProjectInput.builder().addPlatforms(boms).addExtensions(extensionsToAdd).buildTool(invocation.getQuarkusProject().getBuildTool()).example((String)invocation.getValue(CreateProject.EXAMPLE)).noCode(invocation.getValue(CreateProject.NO_CODE, false)).addCodestarts((Collection)invocation.getValue(CreateProject.EXTRA_CODESTARTS, Collections.emptySet())).noBuildToolWrapper(invocation.getValue(CreateProject.NO_BUILDTOOL_WRAPPER, false)).noDockerfiles(invocation.getValue(CreateProject.NO_DOCKERFILES, false)).addData((Map)platformData).addData((Map)QuarkusCodestartData.LegacySupport.convertFromLegacy(invocation.getValues())).putData(QuarkusCodestartData.QuarkusDataKey.APP_CONFIG.key(), invocation.getValue(QuarkusCodestartData.QuarkusDataKey.APP_CONFIG.key(), Collections.emptyMap())).messageWriter(invocation.log()).build();
            invocation.log().info("-----------");
            if (!extensionsToAdd.isEmpty()) {
                invocation.log().info("selected extensions: \n" + extensionsToAdd.stream().map(e -> "- " + e.getGroupId() + ":" + e.getArtifactId() + "\n").collect(Collectors.joining()));
            }
            QuarkusCodestartCatalog catalog = QuarkusCodestartCatalog.fromExtensionsCatalog(invocation.getQuarkusProject().getExtensionsCatalog(), invocation.getQuarkusProject().getCodestartResourceLoaders());
            CodestartProjectDefinition projectDefinition = catalog.createProject(input);
            projectDefinition.generate(invocation.getQuarkusProject().getProjectDirPath());
            invocation.log().info("\n-----------\n" + MessageIcons.OK_ICON + " " + projectDefinition.getRequiredCodestart(CodestartType.PROJECT).getName() + " project has been successfully generated in:\n--> " + invocation.getQuarkusProject().getProjectDirPath().toString() + "\n-----------");
        }
        catch (IOException e2) {
            throw new QuarkusCommandException("Failed to create project: " + e2.getMessage(), e2);
        }
        return QuarkusCommandOutcome.success();
    }

    private List<ArtifactCoords> getExtensionBoms(ExtensionCatalog extensionCatalog, List<ArtifactCoords> extensionsToAdd) throws QuarkusCommandException {
        List<Object> eKeys;
        ElementCatalog ec = (ElementCatalog)extensionCatalog.getMetadata().get("element-catalog");
        if (ec == null) {
            return Collections.emptyList();
        }
        Extension quarkusCore = extensionCatalog.getExtensions().stream().filter(e -> e.getArtifact().getArtifactId().equals("quarkus-core")).findFirst().get();
        if (quarkusCore == null) {
            throw new QuarkusCommandException("Failed to locate quarkus-core in the extension catalog");
        }
        if (extensionsToAdd.isEmpty()) {
            eKeys = Collections.singletonList(quarkusCore.getArtifact().getGroupId() + ":" + quarkusCore.getArtifact().getArtifactId());
        } else {
            eKeys = extensionsToAdd.stream().map(e -> e.getGroupId() + ":" + e.getArtifactId()).collect(Collectors.toList());
            eKeys.add(quarkusCore.getArtifact().getGroupId() + ":" + quarkusCore.getArtifact().getArtifactId());
        }
        return ElementCatalogBuilder.getBoms((ElementCatalog)ec, eKeys);
    }
}

