/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.tools;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.json.JsonCatalogMapperHelper;
import io.quarkus.registry.catalog.json.JsonCatalogMerger;
import io.quarkus.registry.catalog.json.JsonExtensionCatalog;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class ToolsUtils {
    public static String requireProperty(String name) {
        String value = ToolsUtils.getProperty(name);
        if (value == null) {
            throw new IllegalStateException("Failed to resolve required property " + name);
        }
        return value;
    }

    public static String getProperty(String name) {
        return ToolsUtils.getProperty(name, null);
    }

    public static String getProperty(String name, String defaultValue) {
        return System.getProperty(name, defaultValue);
    }

    public static Map<String, String> stringToMap(String str, String entrySeparator, String keyValueSeparator) {
        HashMap<String, String> result = new HashMap<String, String>();
        block4: for (String entry : StringUtils.splitByWholeSeparator((String)str, (String)entrySeparator)) {
            String[] pair = StringUtils.splitByWholeSeparator((String)entry, (String)keyValueSeparator, (int)2);
            if (pair.length > 0 && StringUtils.isBlank((CharSequence)pair[0])) {
                throw new IllegalArgumentException("Entry with empty key " + entry);
            }
            switch (pair.length) {
                case 1: {
                    result.put(pair[0].trim(), "");
                    continue block4;
                }
                case 2: {
                    result.put(pair[0].trim(), pair[1].trim());
                }
            }
        }
        return result;
    }

    public static boolean isNullOrEmpty(String arg) {
        return arg == null || arg.isEmpty();
    }

    public static String dotJoin(String ... parts) {
        if (parts.length == 0) {
            return null;
        }
        if (parts.length == 1) {
            return parts[0];
        }
        StringBuilder buf = new StringBuilder();
        buf.append(parts[0]);
        int i = 1;
        while (i < parts.length) {
            buf.append('.').append(parts[i++]);
        }
        return buf.toString();
    }

    public static ExtensionCatalog resolvePlatformDescriptorDirectly(String bomGroupId, String bomArtifactId, String bomVersion, MavenArtifactResolver artifactResolver, MessageWriter log) {
        Path platformJson;
        block8: {
            if (bomVersion == null) {
                throw new IllegalArgumentException("BOM version was not provided");
            }
            DefaultArtifact catalogCoords = new DefaultArtifact(bomGroupId == null ? "io.quarkus" : bomGroupId, (bomArtifactId == null ? "quarkus-universe-bom" : bomArtifactId) + "-quarkus-platform-descriptor", bomVersion, "json", bomVersion);
            platformJson = null;
            try {
                log.debug("Resolving platform descriptor %s", new Object[]{catalogCoords});
                platformJson = artifactResolver.resolve((Artifact)catalogCoords).getArtifact().getFile().toPath();
            }
            catch (Exception e) {
                if (bomArtifactId == null && catalogCoords.getArtifactId().startsWith("quarkus-universe-bom")) {
                    catalogCoords = new DefaultArtifact(catalogCoords.getGroupId(), "quarkus-bom-quarkus-platform-descriptor", catalogCoords.getClassifier(), catalogCoords.getExtension(), catalogCoords.getVersion());
                    try {
                        log.debug("Resolving platform descriptor %s", new Object[]{catalogCoords});
                        platformJson = artifactResolver.resolve((Artifact)catalogCoords).getArtifact().getFile().toPath();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (platformJson != null) break block8;
                throw new RuntimeException("Failed to resolve the default platform JSON descriptor", e);
            }
        }
        try {
            return (ExtensionCatalog)JsonCatalogMapperHelper.deserialize(platformJson, JsonExtensionCatalog.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize extension catalog " + platformJson, e);
        }
    }

    public static ExtensionCatalog mergePlatforms(List<ArtifactCoords> platforms, MavenArtifactResolver artifactResolver) {
        return ToolsUtils.mergePlatforms(platforms, (AppModelResolver)new BootstrapAppModelResolver(artifactResolver));
    }

    public static ExtensionCatalog mergePlatforms(List<ArtifactCoords> platforms, AppModelResolver artifactResolver) {
        ArrayList<ExtensionCatalog> catalogs = new ArrayList<ExtensionCatalog>(platforms.size());
        for (ArtifactCoords platform : platforms) {
            Path json;
            try {
                json = artifactResolver.resolve(new AppArtifact(platform.getGroupId(), platform.getArtifactId(), platform.getClassifier(), platform.getType(), platform.getVersion()));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to resolve platform descriptor " + platform, e);
            }
            try {
                catalogs.add((ExtensionCatalog)JsonCatalogMapperHelper.deserialize((Path)json, JsonExtensionCatalog.class));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to deserialize platform descriptor " + json, e);
            }
        }
        return JsonCatalogMerger.merge(catalogs);
    }

    public static Properties readQuarkusProperties(ExtensionCatalog catalog) {
        Map map = catalog.getMetadata().getOrDefault("project", Collections.emptyMap());
        map = map.getOrDefault("properties", Collections.emptyMap());
        Properties properties = new Properties();
        map.entrySet().forEach(e -> properties.setProperty(e.getKey().toString(), e.getValue() == null ? null : e.getValue().toString()));
        return properties;
    }

    public static String requireProperty(Properties props, String name) {
        String value = props.getProperty(name);
        if (value == null) {
            throw new IllegalStateException("Failed to resolve required property " + name);
        }
        return value;
    }

    public static String getMavenPluginArtifactId(Properties props) {
        return props.getProperty("maven-plugin-artifactId");
    }

    public static String getMavenPluginGroupId(Properties props) {
        return props.getProperty("maven-plugin-groupId");
    }

    public static String getQuarkusCoreVersion(Properties props) {
        return props.getProperty("quarkus-core-version");
    }

    public static String requireQuarkusCoreVersion(Properties props) {
        return ToolsUtils.requireProperty(props, "quarkus-core-version");
    }

    public static String getMavenPluginVersion(Properties props) {
        return props.getProperty("maven-plugin-version");
    }

    public static String getGradlePluginVersion(Properties props) {
        return props.getProperty("gradle-plugin-version");
    }

    public static String getPluginKey(Properties props) {
        return ToolsUtils.getMavenPluginGroupId(props) + ":" + ToolsUtils.getMavenPluginArtifactId(props);
    }

    public static String getProposedMavenVersion(Properties props) {
        return props.getProperty("proposed-maven-version");
    }

    public static String getMavenWrapperVersion(Properties props) {
        return props.getProperty("maven-wrapper-version");
    }

    public static String getGradleWrapperVersion(Properties props) {
        return props.getProperty("gradle-wrapper-version");
    }
}

