/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.MultipleExtensionsFoundException;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.project.extensions.ExtensionInstallPlan;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.platform.catalog.predicate.ExtensionPredicate;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.union.ElementCatalog;
import io.quarkus.registry.union.ElementCatalogBuilder;
import io.quarkus.registry.union.Member;
import io.quarkus.registry.union.Union;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AddExtensionsCommandHandler
implements QuarkusCommandHandler {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        Set<String> extensionsQuery = invocation.getValue("quarkus.add-extensions.extensions", Collections.emptySet());
        if (extensionsQuery.isEmpty()) {
            return (QuarkusCommandOutcome)QuarkusCommandOutcome.success().setValue("quarkus.add-extensions.outcome-updated", false);
        }
        ExtensionManager extensionManager = invocation.getValue("quarkus.add-extensions.extension-manager", invocation.getQuarkusProject().getExtensionManager());
        try {
            ExtensionInstallPlan extensionInstallPlan = this.planInstallation(invocation, extensionsQuery);
            if (extensionInstallPlan.isInstallable()) {
                ExtensionManager.InstallResult result = extensionManager.install(extensionInstallPlan);
                result.getInstalledPlatforms().forEach(a -> invocation.log().info(MessageIcons.OK_ICON + " Platform " + a.getGroupId() + ":" + a.getArtifactId() + " has been installed"));
                result.getInstalledManagedExtensions().forEach(a -> invocation.log().info(MessageIcons.OK_ICON + " Extension " + a.getGroupId() + ":" + a.getArtifactId() + " has been installed"));
                result.getInstalledIndependentExtensions().forEach(a -> invocation.log().info(MessageIcons.OK_ICON + " Extension " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion() + " has been installed"));
                result.getAlreadyInstalled().forEach(a -> invocation.log().info(MessageIcons.NOOP_ICON + " Extension " + a.getGroupId() + ":" + a.getArtifactId() + " was already installed"));
                return (QuarkusCommandOutcome)new QuarkusCommandOutcome(true).setValue("quarkus.add-extensions.outcome-updated", result.isSourceUpdated());
            }
            if (!extensionInstallPlan.getUnmatchedKeywords().isEmpty()) {
                invocation.log().info(MessageIcons.ERROR_ICON + " Nothing installed because keyword(s) '" + String.join((CharSequence)"', '", extensionInstallPlan.getUnmatchedKeywords()) + "' were not matched in the catalog.");
            } else {
                invocation.log().info(MessageIcons.NOK_ICON + " The provided keyword(s) did not match any extension from the catalog.");
            }
        }
        catch (MultipleExtensionsFoundException m) {
            StringBuilder sb = new StringBuilder();
            sb.append(MessageIcons.ERROR_ICON + " Multiple extensions matching '").append(m.getKeyword()).append("'");
            m.getExtensions().forEach(extension -> sb.append(System.lineSeparator()).append("     * ").append(extension.managementKey()));
            sb.append(System.lineSeparator()).append("     Be more specific e.g using the exact name or the full GAV.");
            invocation.log().info(sb.toString());
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Failed to add extensions", e);
        }
        return (QuarkusCommandOutcome)new QuarkusCommandOutcome(false).setValue("quarkus.add-extensions.outcome-updated", false);
    }

    public ExtensionInstallPlan planInstallation(QuarkusCommandInvocation invocation, Collection<String> keywords) throws IOException {
        Collection unions;
        if (keywords.isEmpty()) {
            return ExtensionInstallPlan.EMPTY;
        }
        ExtensionCatalog catalog = invocation.getExtensionsCatalog();
        String quarkusCore = catalog.getQuarkusCoreVersion();
        Collection<ArtifactCoords> importedPlatforms = invocation.getQuarkusProject().getExtensionManager().getInstalledPlatforms();
        ElementCatalog elementCatalog = ElementCatalogBuilder.getElementCatalog((ExtensionCatalog)catalog, ExtensionCatalog.class);
        Set preferredBoms = Collections.emptySet();
        if (elementCatalog != null && (unions = elementCatalog.unions()).size() > 1) {
            for (Union release : unions) {
                boolean preferredRelease = false;
                for (Member m : release.members()) {
                    if (!((ExtensionCatalog)m.getInstance()).isPlatform() || !importedPlatforms.contains(((ExtensionCatalog)m.getInstance()).getBom())) continue;
                    if (preferredBoms.isEmpty()) {
                        preferredBoms = new HashSet();
                    }
                    preferredRelease = true;
                    break;
                }
                if (!preferredRelease) continue;
                for (Member m : release.members()) {
                    if (!((ExtensionCatalog)m.getInstance()).isPlatform()) continue;
                    preferredBoms.add(((ExtensionCatalog)m.getInstance()).getBom());
                }
            }
        }
        ExtensionInstallPlan.Builder builder = ExtensionInstallPlan.builder();
        for (String keyword : keywords) {
            int countColons = StringUtils.countMatches((CharSequence)keyword, (CharSequence)":");
            if (countColons == 1) {
                ArtifactKey artifactKey = ArtifactKey.fromString((String)keyword);
                builder.addManagedExtension(new ArtifactCoords(artifactKey, null));
                continue;
            }
            if (countColons > 1) {
                builder.addIndependentExtension(ArtifactCoords.fromString((String)keyword));
                continue;
            }
            List<Extension> listed = this.listInternalExtensions(quarkusCore, keyword, catalog.getExtensions());
            if (listed.isEmpty()) {
                builder.addUnmatchedKeyword(keyword);
            } else if (listed.size() > 1 && !ExtensionPredicate.isPattern(keyword)) {
                throw new MultipleExtensionsFoundException(keyword, listed);
            }
            for (Extension e : listed) {
                String groupId = e.getArtifact().getGroupId();
                String artifactId = e.getArtifact().getArtifactId();
                String version = e.getArtifact().getVersion();
                ArtifactCoords extensionCoords = new ArtifactCoords(groupId, artifactId, version);
                boolean managed = false;
                ExtensionOrigin firstPlatform = null;
                ExtensionOrigin preferredOrigin = null;
                for (ExtensionOrigin origin : e.getOrigins()) {
                    if (!origin.isPlatform()) continue;
                    if (importedPlatforms.contains(origin.getBom())) {
                        managed = true;
                        builder.addManagedExtension(extensionCoords);
                        break;
                    }
                    if (preferredOrigin != null) continue;
                    if (preferredBoms.contains(origin.getBom())) {
                        preferredOrigin = origin;
                        continue;
                    }
                    if (firstPlatform != null) continue;
                    firstPlatform = origin;
                }
                if (preferredOrigin == null) {
                    preferredOrigin = firstPlatform;
                }
                if (!managed && preferredOrigin != null) {
                    builder.addManagedExtension(extensionCoords);
                    builder.addPlatform(preferredOrigin.getBom());
                    managed = true;
                }
                if (managed) continue;
                builder.addIndependentExtension(extensionCoords);
            }
        }
        return builder.build();
    }

    private List<Extension> listInternalExtensions(String quarkusCore, String keyword, Collection<Extension> extensions) {
        ArrayList<Extension> result = new ArrayList<Extension>();
        ExtensionPredicate predicate = null;
        if (keyword != null && !keyword.isEmpty()) {
            predicate = new ExtensionPredicate(keyword);
        }
        for (Extension extension : extensions) {
            if (predicate == null) {
                result.add(extension);
                continue;
            }
            if (predicate.isExactMatch(extension)) {
                return Collections.singletonList(extension);
            }
            if (!predicate.test(extension)) continue;
            result.add(extension);
        }
        return result;
    }
}

