/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.codestarts.extension.QuarkusExtensionCodestartCatalog;
import io.quarkus.devtools.codestarts.extension.QuarkusExtensionCodestartProjectInput;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.maven.utilities.PomTransformer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Model;

public class CreateExtensionCommandHandler {
    public QuarkusCommandOutcome execute(MessageWriter log, String groupId, String artifactId, QuarkusExtensionCodestartProjectInput input, Path newExtensionDir) throws QuarkusCommandException {
        return this.execute(log, groupId, artifactId, input, newExtensionDir, null, null, null);
    }

    public QuarkusCommandOutcome execute(MessageWriter log, String groupId, String artifactId, QuarkusExtensionCodestartProjectInput input, Path newExtensionDir, Path extensionsParentDir, Path itTestParentDir, Path bomDir) throws QuarkusCommandException {
        try {
            QuarkusExtensionCodestartCatalog catalog = QuarkusExtensionCodestartCatalog.fromBaseCodestartsResources();
            catalog.createProject(input).generate(newExtensionDir);
            String extensionDirName = newExtensionDir.getFileName().toString();
            if (extensionsParentDir != null) {
                this.updateExtensionsParentPom(extensionDirName, extensionsParentDir);
                log.info(MessageIcons.OK_ICON + " New extension module '%s' added to %s", new Object[]{extensionDirName, extensionsParentDir});
            }
            if (itTestParentDir != null) {
                this.updateITParentPomAndMoveDir(extensionDirName, newExtensionDir, itTestParentDir);
                log.info(MessageIcons.OK_ICON + " New integration test module '%s' added to %s", new Object[]{extensionDirName, itTestParentDir});
            }
            if (bomDir != null) {
                this.updateBom(groupId, artifactId, bomDir);
                log.info(MessageIcons.OK_ICON + " The extension runtime and deployment artifacts have been added to the bom dependenciesManagement: %s", new Object[]{bomDir});
            }
            log.info("\n-----------\n" + MessageIcons.NOOP_ICON + " extension has been successfully generated in:\n--> " + newExtensionDir.toString() + "\n-----------");
            return QuarkusCommandOutcome.success();
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Error while creating Quarkus extension: " + e.getMessage(), e);
        }
    }

    private void updateBom(String groupId, String artifactId, Path bomDir) throws QuarkusCommandException {
        Path bomPom = CreateExtensionCommandHandler.checkPomExists(bomDir);
        ArrayList<PomTransformer.Transformation> transformations = new ArrayList<PomTransformer.Transformation>();
        transformations.add(PomTransformer.Transformation.addManagedDependency(groupId, artifactId, "${project.version}"));
        transformations.add(PomTransformer.Transformation.addManagedDependency(groupId, artifactId + "-deployment", "${project.version}"));
        new PomTransformer(bomPom, StandardCharsets.UTF_8).transform(transformations);
    }

    private void updateITParentPomAndMoveDir(String extensionDirName, Path newExtensionDir, Path itTestDir) throws QuarkusCommandException, IOException {
        Path itTestPom = CreateExtensionCommandHandler.checkPomExists(itTestDir);
        new PomTransformer(itTestPom, StandardCharsets.UTF_8).transform(PomTransformer.Transformation.addModule(extensionDirName));
        FileUtils.moveDirectory((File)newExtensionDir.resolve("integration-tests").toFile(), (File)itTestDir.resolve(extensionDirName).toFile());
    }

    private void updateExtensionsParentPom(String extensionDirName, Path extensionsDir) throws QuarkusCommandException {
        Path extensionsPom = CreateExtensionCommandHandler.checkPomExists(extensionsDir);
        new PomTransformer(extensionsPom, StandardCharsets.UTF_8).transform(PomTransformer.Transformation.addModule(extensionDirName));
    }

    public static Path checkPomExists(Path dir) throws QuarkusCommandException {
        Path pom = dir.resolve("pom.xml");
        if (!Files.exists(pom, new LinkOption[0])) {
            throw new QuarkusCommandException("Invalid directory structure, file not found: " + pom.toString());
        }
        return pom;
    }

    public static Model readPom(Path dir) throws QuarkusCommandException {
        Path pom = CreateExtensionCommandHandler.checkPomExists(dir);
        try {
            return MojoUtils.readPom(pom.toFile());
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Error while reading pom: " + pom.toString(), e);
        }
    }
}

