/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.utils;

import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class Prompter {
    private final LineReader lineReader;

    public Prompter() throws IOException {
        Terminal terminal = TerminalBuilder.builder().dumb(true).build();
        this.lineReader = LineReaderBuilder.builder().terminal(terminal).build();
    }

    public String prompt(String message, Character mask) throws IOException {
        String value;
        Objects.requireNonNull(message);
        String prompt = String.format("%s: ", message);
        while (StringUtils.isBlank((CharSequence)(value = this.lineReader.readLine(prompt, mask)))) {
        }
        return value;
    }

    public String prompt(String message) throws IOException {
        Objects.requireNonNull(message);
        return this.prompt(message, null);
    }

    public String promptWithDefaultValue(String message, String defaultValue) throws IOException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(defaultValue);
        String prompt = String.format("%s [%s]: ", message, defaultValue);
        String value = this.lineReader.readLine(prompt);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }
}

