/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.devtools.commands.CreateProjectHelper;
import io.quarkus.devtools.commands.SourceType;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.CreateProjectCommandHandler;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.platform.tools.ToolsUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CreateProject {
    private QuarkusProject quarkusProject;
    private String javaVersion;
    private Set<String> extensions = new HashSet<String>();
    private Map<String, Object> values = new HashMap<String, Object>();

    public CreateProject(QuarkusProject project) {
        this.quarkusProject = Objects.requireNonNull(project, "project is required");
    }

    public CreateProject groupId(String groupId) {
        this.setValue("project.group-id", groupId);
        return this;
    }

    public CreateProject artifactId(String artifactId) {
        this.setValue("project.artifact-id", artifactId);
        return this;
    }

    public CreateProject version(String version) {
        this.setValue("project.version", version);
        return this;
    }

    public CreateProject name(String name) {
        if (name == null || name.isBlank()) {
            return this;
        }
        this.setValue("project.name", name);
        return this;
    }

    public CreateProject description(String description) {
        if (description == null || description.isBlank()) {
            return this;
        }
        this.setValue("project.description", description);
        return this;
    }

    @Deprecated
    public CreateProject quarkusMavenPluginVersion(String version) {
        this.setValue("maven-plugin-version", version);
        return this;
    }

    @Deprecated
    public CreateProject quarkusGradlePluginVersion(String version) {
        this.setValue("gradle-plugin-version", version);
        return this;
    }

    public CreateProject quarkusPluginVersion(String version) {
        if (this.quarkusProject.getBuildTool().equals((Object)BuildTool.MAVEN)) {
            this.setValue("maven-plugin-version", version);
        } else {
            this.setValue("gradle-plugin-version", version);
        }
        return this;
    }

    public CreateProject extraCodestarts(Set<String> extraCodestarts) {
        this.setValue("codegen.extra-codestarts", extraCodestarts);
        return this;
    }

    public CreateProject javaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
        return this;
    }

    public CreateProject resourcePath(String resourcePath) {
        this.setValue("project.resource.path", resourcePath);
        return this;
    }

    public CreateProject resourceClassName(String resourceClassName) {
        if (resourceClassName == null) {
            return this;
        }
        CreateProjectHelper.checkClassName(resourceClassName);
        this.setValue("project.resource.class-name", resourceClassName);
        return this;
    }

    public CreateProject appConfig(String appConfigAsString) {
        Map<Object, Object> configMap = Collections.emptyMap();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appConfigAsString})) {
            configMap = ToolsUtils.stringToMap(appConfigAsString, ",", "=");
        }
        this.setValue("project.app-config", configMap);
        return this;
    }

    public CreateProject packageName(String packageName) {
        if (packageName == null) {
            return this;
        }
        packageName = CreateProjectHelper.checkPackageName(packageName);
        this.setValue("project.package-name", packageName);
        return this;
    }

    public CreateProject extensions(Set<String> extensions) {
        if (extensions == null) {
            return this;
        }
        this.extensions.addAll(extensions);
        return this;
    }

    public CreateProject example(String example) {
        this.setValue("codegen.example", example);
        return this;
    }

    public CreateProject noCode(boolean value) {
        this.setValue("codegen.no-code", value);
        return this;
    }

    public CreateProject noCode() {
        return this.noCode(true);
    }

    public CreateProject noBuildToolWrapper(boolean value) {
        this.setValue("codegen.no-buildtool-wrapper", value);
        return this;
    }

    public CreateProject noBuildToolWrapper() {
        return this.noBuildToolWrapper(true);
    }

    public CreateProject noDockerfiles(boolean value) {
        this.setValue("codegen.no-dockerfiles", value);
        return this;
    }

    public CreateProject noDockerfiles() {
        return this.noDockerfiles(true);
    }

    public CreateProject setValue(String name, Object value) {
        if (value != null) {
            this.values.put(name, value);
        }
        return this;
    }

    public boolean doCreateProject(Map<String, Object> context) throws QuarkusCommandException {
        if (context != null && !context.isEmpty()) {
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                if (entry.getValue() == null) continue;
                this.setValue(entry.getKey(), entry.getValue());
            }
        }
        return this.execute().isSuccess();
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        SourceType sourceType = SourceType.resolve(this.extensions);
        this.setValue("project.java-version", CreateProjectHelper.computeJavaVersion(sourceType, this.javaVersion));
        CreateProjectHelper.handleSpringConfiguration(this.values, this.extensions);
        this.setValue("project.extensions", this.extensions);
        QuarkusCommandInvocation invocation = new QuarkusCommandInvocation(this.quarkusProject, this.values);
        return new CreateProjectCommandHandler().execute(invocation);
    }

    public static interface CreateProjectKey {
        public static final String PROJECT_GROUP_ID = "project.group-id";
        public static final String PROJECT_ARTIFACT_ID = "project.artifact-id";
        public static final String PROJECT_VERSION = "project.version";
        public static final String PROJECT_NAME = "project.name";
        public static final String PROJECT_DESCRIPTION = "project.description";
        public static final String PACKAGE_NAME = "project.package-name";
        public static final String EXTENSIONS = "project.extensions";
        public static final String RESOURCE_CLASS_NAME = "project.resource.class-name";
        public static final String RESOURCE_PATH = "project.resource.path";
        public static final String JAVA_VERSION = "project.java-version";
        public static final String APP_CONFIG = "project.app-config";
        public static final String QUARKUS_VERSION = "quarkus-version";
        public static final String NO_DOCKERFILES = "codegen.no-dockerfiles";
        public static final String NO_BUILDTOOL_WRAPPER = "codegen.no-buildtool-wrapper";
        public static final String NO_CODE = "codegen.no-code";
        public static final String EXAMPLE = "codegen.example";
        public static final String EXTRA_CODESTARTS = "codegen.extra-codestarts";
    }
}

