/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.UpdateProjectCommandHandler;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.util.HashMap;
import java.util.Objects;

public class UpdateProject {
    public static final String APP_MODEL = "quarkus.update-project.app-model";
    public static final String LATEST_CATALOG = "quarkus.update-project.latest-catalog";
    public static final String PER_MODULE = "quarkus.update-project.per-module";
    public static final String GENERATE_REWRITE_CONFIG = "quarkus.update-project.generate-update-config";
    public static final String TARGET_PLATFORM_VERSION = "quarkus.update-project.target-platform-version";
    private final QuarkusCommandInvocation invocation;
    private final UpdateProjectCommandHandler handler = new UpdateProjectCommandHandler();

    public UpdateProject(QuarkusProject quarkusProject) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject);
    }

    public UpdateProject(QuarkusProject quarkusProject, MessageWriter messageWriter) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject, new HashMap<String, Object>(), messageWriter);
    }

    public UpdateProject latestCatalog(ExtensionCatalog latestCatalog) {
        this.invocation.setValue(LATEST_CATALOG, Objects.requireNonNull(latestCatalog, "latestCatalog is required"));
        return this;
    }

    public UpdateProject appModel(ApplicationModel applicationModel) {
        this.invocation.setValue(APP_MODEL, Objects.requireNonNull(applicationModel, "applicationModel is required"));
        return this;
    }

    public UpdateProject generateRewriteConfig(boolean generateUpdateConfig) {
        this.invocation.setValue(GENERATE_REWRITE_CONFIG, generateUpdateConfig);
        return this;
    }

    public UpdateProject perModule(boolean perModule) {
        this.invocation.setValue(PER_MODULE, perModule);
        return this;
    }

    public UpdateProject targetPlatformVersion(String targetPlatformVersion) {
        this.invocation.setValue(TARGET_PLATFORM_VERSION, targetPlatformVersion);
        return this;
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        return this.handler.execute(this.invocation);
    }
}

