/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.descriptor.loader.json.ResourceLoaders;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public final class QuarkusUpdatesRepository {
    private static final String QUARKUS_RECIPE_GAV = "io.quarkus:quarkus-update-recipes:LATEST";

    private QuarkusUpdatesRepository() {
    }

    public static List<String> fetchLatestRecipes(MavenArtifactResolver artifactResolver, String currentVersion, String targetVersion) {
        try {
            ResourceLoader resourceLoader = ResourceLoaders.resolveFileResourceLoader(artifactResolver.resolve(DependencyUtils.toArtifact((String)QUARKUS_RECIPE_GAV)).getArtifact().getFile());
            return resourceLoader.loadResourceAsPath("quarkus-updates/core", path -> {
                try (Stream<Path> pathStream = Files.walk(path, new FileVisitOption[0]);){
                    List list = pathStream.filter(p -> p.getFileName().toString().matches("^\\d\\H+.ya?ml$")).filter(p -> QuarkusUpdatesRepository.shouldApplyRecipe(p.getFileName().toString(), currentVersion, targetVersion)).map(p -> {
                        try {
                            return new String(Files.readAllBytes(p));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }).collect(Collectors.toList());
                    return list;
                }
            });
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to resolve artifact io.quarkus:quarkus-update-recipes:LATEST", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load recipes in artifact io.quarkus:quarkus-update-recipes:LATEST", e);
        }
    }

    static boolean shouldApplyRecipe(String recipeFileName, String currentVersion, String targetVersion) {
        String recipeVersion = recipeFileName.replaceFirst("[.][^.]+$", "");
        DefaultArtifactVersion recipeAVersion = new DefaultArtifactVersion(recipeVersion);
        DefaultArtifactVersion currentAVersion = new DefaultArtifactVersion(currentVersion);
        DefaultArtifactVersion targetAVersion = new DefaultArtifactVersion(targetVersion);
        return currentAVersion.compareTo((ArtifactVersion)recipeAVersion) < 0 && targetAVersion.compareTo((ArtifactVersion)recipeAVersion) >= 0;
    }
}

