/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.catalog.processor;

import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.platform.catalog.processor.ExtendedKeywords;
import io.quarkus.platform.catalog.processor.MetadataValue;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionOrigin;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class ExtensionProcessor {
    private static final String QUARKUS_BOM_ARTIFACT_ID = "quarkus-bom";
    private final Extension extension;

    private ExtensionProcessor(Extension extension) {
        this.extension = Objects.requireNonNull(extension);
    }

    public static ExtensionProcessor of(Extension extension) {
        return new ExtensionProcessor(extension);
    }

    public static String getShortName(Extension extension) {
        String shortName = ExtensionProcessor.getMetadataValue(extension, "short-name").asString();
        return shortName == null ? "" : shortName;
    }

    public static String getGuide(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "guide").asString();
    }

    public static Integer getMinimumJavaVersion(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "minimum-java-version").asInteger();
    }

    public static List<String> getCategories(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "categories").asStringList();
    }

    public static String getBuiltWithQuarkusCore(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "built-with-quarkus-core").asString();
    }

    public static String getCodestartName(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "codestart.name").asString();
    }

    public static Optional<ArtifactCoords> getBom(Extension extension) {
        if (extension == null || extension.getOrigins() == null || extension.getOrigins().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((ExtensionOrigin)extension.getOrigins().get(0)).getBom());
    }

    public static Optional<ArtifactCoords> getNonQuarkusBomOnly(Extension extension) {
        return ExtensionProcessor.getBom(extension).filter(p -> !p.getArtifactId().equals(QUARKUS_BOM_ARTIFACT_ID));
    }

    public static List<String> getCodestartLanguages(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "codestart.languages").asStringList();
    }

    public static String getCodestartArtifact(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "codestart.artifact").asString();
    }

    public static CodestartKind getCodestartKind(Extension extension) {
        if (ExtensionProcessor.getCodestartName(extension) == null) {
            return null;
        }
        return ExtensionProcessor.getMetadataValue(extension, "codestart.kind").toEnum(CodestartKind.class, CodestartKind.EXTENSION_CODESTART);
    }

    public static boolean providesCode(Extension extension) {
        CodestartKind codestartKind = ExtensionProcessor.getCodestartKind(extension);
        return codestartKind != null && codestartKind.providesCode();
    }

    public static boolean isUnlisted(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "unlisted").asBoolean();
    }

    public static List<String> getKeywords(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "keywords").asStringList();
    }

    public static Set<String> getExtendedKeywords(Extension extension) {
        return ExtendedKeywords.extendsKeywords(extension.getArtifact().getArtifactId(), extension.getName(), ExtensionProcessor.getShortName(extension), ExtensionProcessor.getCategories(extension), extension.getDescription(), ExtensionProcessor.getKeywords(extension));
    }

    public static Map<String, Collection<String>> getSyntheticMetadata(Extension extension) {
        HashMap<String, Object> extendedMetadata = new HashMap<String, Object>(extension.getMetadata());
        ArrayList<String> withList = new ArrayList<String>(ExtensionProcessor.getMetadataValue(extension, "with").asStringList());
        if (ExtensionProcessor.providesCode(extension)) {
            withList.add("starter-code");
        }
        extendedMetadata.put("with", withList);
        extendedMetadata.put("origin", extension.hasPlatformOrigin() ? "platform" : "other");
        if (ExtensionProcessor.getMetadataValue(extension, "status").isEmpty()) {
            extendedMetadata.put("status", "stable");
        }
        return extendedMetadata.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry<String, List<String>>((String)e.getKey(), new MetadataValue(e.getValue()).asStringList())).filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Extension getExtension() {
        return this.extension;
    }

    public Optional<ArtifactCoords> getBom() {
        return ExtensionProcessor.getBom(this.extension);
    }

    public Optional<ArtifactCoords> getNonQuarkusBomOnly() {
        return ExtensionProcessor.getNonQuarkusBomOnly(this.extension);
    }

    public String getBuiltWithQuarkusCore() {
        return ExtensionProcessor.getBuiltWithQuarkusCore(this.extension);
    }

    public String getGuide() {
        return ExtensionProcessor.getGuide(this.extension);
    }

    public String getShortName() {
        return ExtensionProcessor.getShortName(this.extension);
    }

    public String getCodestartName() {
        return ExtensionProcessor.getCodestartName(this.extension);
    }

    public List<String> getCategories() {
        return ExtensionProcessor.getCategories(this.extension);
    }

    public List<String> getCodestartLanguages() {
        return ExtensionProcessor.getCodestartLanguages(this.extension);
    }

    public String getCodestartArtifact() {
        return ExtensionProcessor.getCodestartArtifact(this.extension);
    }

    public CodestartKind getCodestartKind() {
        return ExtensionProcessor.getCodestartKind(this.extension);
    }

    public boolean providesCode() {
        return ExtensionProcessor.providesCode(this.extension);
    }

    public boolean isUnlisted() {
        return ExtensionProcessor.isUnlisted(this.extension);
    }

    public List<String> getKeywords() {
        return ExtensionProcessor.getKeywords(this.extension);
    }

    public Integer getMinimumJavaVersion() {
        return ExtensionProcessor.getMinimumJavaVersion(this.extension);
    }

    public Set<String> getExtendedKeywords() {
        return ExtensionProcessor.getExtendedKeywords(this.extension);
    }

    public Map<String, Collection<String>> getSyntheticMetadata() {
        return ExtensionProcessor.getSyntheticMetadata(this.extension);
    }

    public static MetadataValue getMetadataValue(Extension extension, String path) {
        return MetadataValue.get(extension.getMetadata(), path);
    }

    public static enum CodestartKind {
        CORE,
        EXTENSION_CODESTART,
        EXAMPLE,
        SINGLETON_EXAMPLE;


        public boolean providesCode() {
            return this == EXTENSION_CODESTART || this == EXAMPLE || this == SINGLETON_EXAMPLE;
        }
    }
}

