/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkus.cli.plugin.PluginType;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Plugin {
    private final String name;
    private final PluginType type;
    private final Optional<String> location;
    private final Optional<String> description;
    @JsonIgnore
    private final boolean inUserCatalog;
    @JsonIgnore
    private final Optional<Path> catalogLocation;

    public Plugin(String name, PluginType type) {
        this(name, type, Optional.empty(), Optional.empty(), Optional.empty(), true);
    }

    @JsonCreator
    public Plugin(@JsonProperty(value="name") String name, @JsonProperty(value="type") PluginType type, @JsonProperty(value="location") Optional<String> location, @JsonProperty(value="description") Optional<String> description) {
        this(name, type, location, description, Optional.empty(), true);
    }

    public Plugin(String name, PluginType type, Optional<String> location, Optional<String> description, Optional<Path> catalogLocation, boolean inUserCatalog) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.description = description != null ? description : Optional.empty();
        this.location = location != null ? location : Optional.empty();
        this.catalogLocation = catalogLocation != null ? catalogLocation : Optional.empty();
        this.inUserCatalog = inUserCatalog;
    }

    public String getName() {
        return this.name;
    }

    public PluginType getType() {
        return this.type;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Optional<String> getLocation() {
        return this.location;
    }

    public boolean isInUserCatalog() {
        return this.inUserCatalog;
    }

    public Optional<Path> getCatalogLocation() {
        return this.catalogLocation;
    }

    public Plugin withDescription(Optional<String> description) {
        return new Plugin(this.name, this.type, this.location, description, this.catalogLocation, this.inUserCatalog);
    }

    public Plugin withCatalogLocation(Optional<Path> catalogLocation) {
        return new Plugin(this.name, this.type, this.location, this.description, catalogLocation, this.inUserCatalog);
    }

    public Plugin inUserCatalog() {
        return new Plugin(this.name, this.type, this.location, this.description, this.catalogLocation, true);
    }

    public Plugin inProjectCatalog() {
        return new Plugin(this.name, this.type, this.location, this.description, this.catalogLocation, false);
    }
}

