/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.plugin.CatalogService;
import io.quarkus.cli.plugin.Plugin;
import io.quarkus.cli.plugin.PluginCatalog;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class PluginCatalogService
extends CatalogService<PluginCatalog> {
    private static final Function<Path, Path> RELATIVE_CATALOG_JSON = p -> p.resolve(".quarkus").resolve("cli").resolve("plugins").resolve("quarkus-cli-catalog.json");

    public PluginCatalogService() {
        this(GIT_ROOT, RELATIVE_CATALOG_JSON);
    }

    public PluginCatalogService(Function<Path, Path> relativePath) {
        this(GIT_ROOT, relativePath);
    }

    public PluginCatalogService(Predicate<Path> projectRoot, Function<Path, Path> relativePath) {
        super(PluginCatalog.class, projectRoot, relativePath);
    }

    @Override
    public Optional<PluginCatalog> readUserCatalog(Optional<Path> userDir) {
        return super.readUserCatalog(userDir).map(u -> u.withCatalogLocation((Optional)userDir.map(RELATIVE_CATALOG_JSON)));
    }

    @Override
    public Optional<PluginCatalog> readProjectCatalog(Optional<Path> dir) {
        return super.readProjectCatalog(dir).map(p -> p.withCatalogLocation((Optional)dir.map(RELATIVE_CATALOG_JSON)));
    }

    public PluginCatalog readCombinedCatalog(Optional<Path> proejctDir, Optional<Path> userDir) {
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        Optional<PluginCatalog> projectCatalog = this.readProjectCatalog(proejctDir);
        Optional<PluginCatalog> userCatalog = this.readUserCatalog(userDir);
        userCatalog.ifPresent(u -> plugins.putAll(u.getPlugins()));
        projectCatalog.ifPresent(p -> plugins.putAll(p.getPlugins()));
        LocalDateTime userCatalogTime = userCatalog.map(PluginCatalog::getLastUpdateDate).orElse(LocalDateTime.now());
        LocalDateTime projectCatalogTime = projectCatalog.map(PluginCatalog::getLastUpdateDate).orElse(LocalDateTime.now());
        LocalDateTime oldest = userCatalogTime.isBefore(projectCatalogTime) ? userCatalogTime : projectCatalogTime;
        return new PluginCatalog("v1", oldest, plugins, Optional.empty());
    }
}

