/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.plugin.Plugin;
import io.quarkus.cli.plugin.PluginCatalog;
import io.quarkus.cli.plugin.PluginCatalogService;
import io.quarkus.cli.plugin.PluginManagerSettings;
import io.quarkus.cli.plugin.PluginManagerUtil;
import io.quarkus.cli.plugin.PluginMangerState;
import io.quarkus.cli.plugin.PluginType;
import io.quarkus.cli.plugin.PluginUtil;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PluginManager {
    private final MessageWriter output;
    private final PluginMangerState state;
    private final PluginManagerSettings settings;
    private final PluginManagerUtil util;

    public PluginManager(PluginManagerSettings settings, MessageWriter output, Optional<Path> userHome, Optional<Path> projectRoot, Optional<QuarkusProject> quarkusProject, Predicate<Plugin> pluginFilter) {
        this.settings = settings;
        this.output = output;
        this.util = PluginManagerUtil.getUtil(settings);
        this.state = new PluginMangerState(settings, output, userHome, projectRoot, quarkusProject, pluginFilter);
    }

    public Optional<Plugin> addPlugin(String nameOrLocation) {
        return this.addPlugin(nameOrLocation, Optional.empty());
    }

    public Optional<Plugin> addPlugin(String nameOrLocation, Optional<String> description) {
        PluginCatalogService pluginCatalogService = this.state.getPluginCatalogService();
        String name = this.util.getName(nameOrLocation);
        if (PluginUtil.isRemoteLocation(nameOrLocation)) {
            Plugin plugin = new Plugin(name, PluginUtil.getType(nameOrLocation), Optional.of(nameOrLocation), description);
            PluginCatalog updatedCatalog = this.state.getPluginCatalog().addPlugin(plugin);
            pluginCatalogService.writeCatalog(updatedCatalog);
            return Optional.of(plugin);
        }
        Map<String, Plugin> installablePlugins = this.state.installablePlugins();
        Optional<Plugin> plugin = Optional.ofNullable(installablePlugins.get(name));
        return plugin.map(p -> {
            PluginCatalog updatedCatalog = this.state.getPluginCatalog().addPlugin((Plugin)p);
            pluginCatalogService.writeCatalog(updatedCatalog);
            return p;
        });
    }

    public Optional<Plugin> addPlugin(Plugin plugin) {
        PluginCatalogService pluginCatalogService = this.state.getPluginCatalogService();
        PluginCatalog updatedCatalog = this.state.getPluginCatalog().addPlugin(plugin);
        pluginCatalogService.writeCatalog(updatedCatalog);
        return Optional.of(plugin);
    }

    public Optional<Plugin> removePlugin(String name) {
        PluginCatalogService pluginCatalogService = this.state.getPluginCatalogService();
        Plugin plugin = this.state.getInstalledPluigns().get(name);
        if (plugin == null) {
            return Optional.empty();
        }
        if (this.state.getProjectCatalog().map(PluginCatalog::getPlugins).map(p -> p.containsKey(name)).orElse(false).booleanValue()) {
            pluginCatalogService.writeCatalog(this.state.getProjectCatalog().orElseThrow(() -> new IllegalStateException("Project catalog should be available!")).removePlugin(name));
            return Optional.of(plugin);
        }
        pluginCatalogService.writeCatalog(this.state.getUserCatalog().orElseThrow(() -> new IllegalStateException("User catalog should be available!")).removePlugin(name));
        return Optional.of(plugin);
    }

    public Optional<Plugin> removePlugin(Plugin plugin) {
        return this.removePlugin(plugin.getName());
    }

    public boolean reconcile() {
        if (this.state.getUserCatalog().map(c -> this.reconcile((PluginCatalog)c)).orElse(false) | this.state.getProjectCatalog().map(c -> this.reconcile((PluginCatalog)c)).orElse(false)) {
            this.state.invalidate();
            return true;
        }
        return false;
    }

    private boolean reconcile(PluginCatalog catalog) {
        Path location = catalog.getCatalogLocation().orElseThrow(() -> new IllegalArgumentException("Unknwon plugin catalog location."));
        List<PluginType> installedTypes = catalog.getPlugins().entrySet().stream().map(Map.Entry::getValue).map(Plugin::getType).collect(Collectors.toList());
        Map<String, Plugin> installablePlugins = this.state.installablePlugins(installedTypes);
        Map<String, Plugin> unreachable = catalog.getPlugins().entrySet().stream().filter(i -> !installablePlugins.containsKey(i.getKey())).filter(i -> PluginUtil.shouldRemove((Plugin)i.getValue())).collect(Collectors.toMap(m -> (String)m.getKey(), m -> (Plugin)m.getValue()));
        if (unreachable.isEmpty()) {
            return false;
        }
        Path backupLocation = location.getParent().resolve("quarkus-cli-catalog.json.bkp");
        this.output.warn("The following plugins found in the catalog: [%s] but no longer available: %s.\nThe unavailable plugin will be purged! A backup of the catalog will be saved at: [%s].", new Object[]{location, unreachable.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.joining(", ", "[", "]")), backupLocation});
        PluginCatalogService pluginCatalogService = this.state.getPluginCatalogService();
        pluginCatalogService.writeCatalog(catalog.withCatalogLocation((Optional)Optional.of(backupLocation)));
        for (String u : unreachable.keySet()) {
            catalog = catalog.removePlugin(u);
        }
        pluginCatalogService.writeCatalog(catalog);
        return true;
    }

    public boolean sync() {
        boolean catalogModified = this.reconcile();
        Map<String, Plugin> installedPlugins = this.getInstalledPlugins();
        Map<String, Plugin> extensionPlugins = this.state.getExtensionPlugins();
        Map<String, Plugin> pluginsToInstall = extensionPlugins.entrySet().stream().filter(e -> !installedPlugins.containsKey(e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Plugin)e.getValue()));
        catalogModified = catalogModified || !pluginsToInstall.isEmpty();
        pluginsToInstall.forEach((name, plugin) -> this.addPlugin((Plugin)plugin));
        this.state.invalidate();
        if (!catalogModified) {
            PluginCatalogService pluginCatalogService = this.state.getPluginCatalogService();
            PluginCatalog catalog = this.state.getPluginCatalog();
            pluginCatalogService.writeCatalog(catalog);
        }
        return catalogModified;
    }

    public boolean syncIfNeeded() {
        if (!this.settings.isInteractiveMode()) {
            return false;
        }
        PluginCatalog catalog = this.state.getCombinedCatalog();
        if (PluginUtil.shouldSync(this.state.getProjectRoot(), catalog)) {
            this.output.info("Plugin catalog last updated on: " + catalog.getLastUpdate() + ". Syncing!");
            return this.sync();
        }
        return false;
    }

    public Map<String, Plugin> getInstalledPlugins() {
        return this.state.getInstalledPluigns();
    }

    public Map<String, Plugin> getInstallablePlugins() {
        return this.state.getInstallablePlugins();
    }
}

