/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.plugin.Plugin;
import io.quarkus.cli.plugin.PluginManagerSettings;
import io.quarkus.cli.plugin.PluginType;
import io.quarkus.cli.plugin.PluginUtil;
import io.quarkus.maven.dependency.GACTV;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PluginManagerUtil {
    private static final Pattern CLI_SUFFIX = Pattern.compile("(\\-cli)(@\\w+)?$");
    private final PluginManagerSettings settings;

    public static PluginManagerUtil getUtil(PluginManagerSettings settings) {
        return new PluginManagerUtil(settings);
    }

    public static PluginManagerUtil getUtil() {
        return PluginManagerUtil.getUtil(PluginManagerSettings.defaultSettings());
    }

    public PluginManagerUtil(PluginManagerSettings settings) {
        this.settings = settings;
    }

    public Plugin from(String location) {
        Optional<URL> url = PluginUtil.checkUrl(location);
        Optional<Path> path = PluginUtil.checkPath(location);
        Optional<GACTV> gactv = PluginUtil.checkGACTV(location);
        String name = this.getName(gactv, url, path);
        PluginType type = PluginUtil.getType(gactv, url, path);
        return new Plugin(name, type, Optional.of(location), Optional.empty());
    }

    public String getName(String location) {
        Optional<URL> url = PluginUtil.checkUrl(location);
        Optional<Path> path = PluginUtil.checkPath(location);
        Optional<GACTV> gactv = PluginUtil.checkGACTV(location);
        return this.getName(gactv, url, path);
    }

    public String getName(Optional<GACTV> gactv, Optional<URL> url, Optional<Path> path) {
        String prefix = this.settings.getPluginPrefix();
        return gactv.map(GACTV::getArtifactId).or(() -> url.map(URL::getPath).map(s -> s.substring(s.lastIndexOf("/") + 1)).map(s -> s.replaceAll("\\.jar$", ""))).or(() -> path.map(Path::getFileName).map(Path::toString).map(s -> s.replaceAll("\\.jar$", ""))).map(n -> this.stripCliSuffix((String)n)).map(n -> n.replaceAll("^" + prefix + "\\-cli\\-", prefix)).map(n -> n.replaceAll("^" + prefix + "\\-", "")).map(n -> n.replaceAll("@.*$", "")).orElseThrow(() -> new IllegalStateException("Could not determinate name for location."));
    }

    private String stripCliSuffix(String s) {
        Matcher m = CLI_SUFFIX.matcher(s);
        if (m.find()) {
            String replacement = m.group(2);
            replacement = replacement != null ? replacement : "";
            return m.replaceAll(replacement);
        }
        return s;
    }
}

