/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.plugin.Plugin;
import io.quarkus.cli.plugin.PluginCatalog;
import io.quarkus.cli.plugin.PluginType;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.maven.dependency.GACTV;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

public final class PluginUtil {
    private static final Pattern CLI_SUFFIX = Pattern.compile("(\\-cli)(@\\w+)?$");

    private PluginUtil() {
    }

    public static boolean shouldSync(Path projectRoot, PluginCatalog catalog) {
        return PluginUtil.shouldSync(Optional.ofNullable(projectRoot), catalog);
    }

    public static boolean shouldSync(Optional<Path> projectRoot, PluginCatalog catalog) {
        LocalDateTime lastBuildFileModifiedTime;
        LocalDateTime catalogTime = catalog.getLastUpdateDate();
        return catalogTime.isBefore(lastBuildFileModifiedTime = PluginUtil.getLastBuildFileModifiedTime(projectRoot)) || LocalDateTime.now().minusDays(7L).isAfter(catalogTime);
    }

    public static PluginType getType(String location) {
        Optional<URL> url = PluginUtil.checkUrl(location);
        Optional<Path> path = PluginUtil.checkPath(location);
        Optional<GACTV> gactv = PluginUtil.checkGACTV(location);
        return PluginUtil.getType(gactv, url, path);
    }

    public static PluginType getType(Optional<GACTV> gactv, Optional<URL> url, Optional<Path> path) {
        return gactv.map(i -> PluginType.maven).or(() -> url.map(u -> u.getPath()).or(() -> path.map(Path::toAbsolutePath).map(Path::toString)).filter(f -> f.endsWith(".jar")).map(i -> PluginType.jar)).or(() -> path.filter(p -> p.toFile().exists()).map(i -> PluginType.executable)).orElse(PluginType.jbang);
    }

    public static boolean shouldRemove(Plugin p) {
        if (p == null) {
            return true;
        }
        if (!p.getLocation().isPresent()) {
            return true;
        }
        if (p.getType() == PluginType.executable) {
            return PluginUtil.checkPath(p.getLocation()).map(Path::toFile).map(File::exists).orElse(false) == false;
        }
        if (PluginUtil.checkUrl(p.getLocation()).isPresent()) {
            return false;
        }
        return !PluginUtil.checkGACTV(p.getLocation()).isPresent();
    }

    public static Optional<URL> checkUrl(String location) {
        try {
            return Optional.of(new URL(location));
        }
        catch (NullPointerException | MalformedURLException e) {
            return Optional.empty();
        }
    }

    public static Optional<URL> checkUrl(Optional<String> location) {
        return location.flatMap(PluginUtil::checkUrl);
    }

    public static Optional<GACTV> checkGACTV(String location) {
        try {
            return Optional.of(GACTV.fromString((String)location));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Optional.empty();
        }
    }

    public static Optional<GACTV> checkGACTV(Optional<String> location) {
        return location.flatMap(PluginUtil::checkGACTV);
    }

    public static Optional<Path> checkPath(String location) {
        try {
            return Optional.of(Path.of(location, new String[0]));
        }
        catch (NullPointerException | InvalidPathException e) {
            return Optional.empty();
        }
    }

    public static Optional<Path> checkPath(Optional<String> location) {
        return location.flatMap(PluginUtil::checkPath);
    }

    public static boolean isRemoteLocation(String location) {
        return PluginUtil.checkUrl(location).isPresent() || PluginUtil.checkGACTV(location).isPresent();
    }

    private static List<Path> getBuildFiles(Optional<Path> projectRoot) {
        ArrayList<Path> buildFiles = new ArrayList<Path>();
        if (projectRoot == null) {
            return buildFiles;
        }
        projectRoot.ifPresent(root -> {
            BuildTool buildTool = QuarkusProjectHelper.detectExistingBuildTool(root);
            if (buildTool != null) {
                for (String buildFile : buildTool.getBuildFiles()) {
                    buildFiles.add(root.resolve(buildFile));
                }
            }
        });
        return buildFiles;
    }

    private static LocalDateTime getLastBuildFileModifiedTime(Optional<Path> projectRoot) {
        long lastModifiedMillis = PluginUtil.getBuildFiles(projectRoot).stream().map(Path::toFile).filter(File::exists).map(File::lastModified).max(Long::compare).orElse(0L);
        return Instant.ofEpochMilli(lastModifiedMillis).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}

